/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.transaction;

import io.micronaut.configuration.mongo.core.NamedMongoConfiguration;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.mongodb.conf.RequiresReactiveMongo;
import io.micronaut.transaction.SynchronousTransactionManager;
import io.micronaut.transaction.async.AsyncTransactionOperations;
import io.micronaut.transaction.async.AsyncUsingReactiveTransactionOperations;
import io.micronaut.transaction.interceptor.CoroutineTxHelper;
import io.micronaut.transaction.reactive.ReactorReactiveTransactionOperations;
import io.micronaut.transaction.sync.SynchronousFromReactiveTransactionManager;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.concurrent.ExecutorService;

@RequiresReactiveMongo
@Factory
@Internal
final class MongoReactiveTransactionManagerFactory {
    MongoReactiveTransactionManagerFactory() {
    }

    @Requires(missingProperty="mongodb.servers")
    @Primary
    @Singleton
    <T> SynchronousTransactionManager<T> buildPrimarySynchronousTransactionManager(@Primary ReactorReactiveTransactionOperations<T> reactiveTransactionOperations, @Named(value="io") ExecutorService executorService) {
        return new SynchronousFromReactiveTransactionManager(reactiveTransactionOperations, executorService);
    }

    @EachBean(value=NamedMongoConfiguration.class)
    <T> SynchronousTransactionManager<T> buildSynchronousTransactionManager(@Parameter ReactorReactiveTransactionOperations<T> reactiveTransactionOperations, @Named(value="io") ExecutorService executorService) {
        return new SynchronousFromReactiveTransactionManager(reactiveTransactionOperations, executorService);
    }

    @Requires(missingProperty="mongodb.servers")
    @Primary
    @Singleton
    <T> AsyncTransactionOperations<T> buildPrimaryAsyncTransactionOperations(@Primary ReactorReactiveTransactionOperations<T> reactiveTransactionOperations, @Nullable CoroutineTxHelper coroutineTxHelper, @Named(value="io") ExecutorService executorService) {
        return new AsyncUsingReactiveTransactionOperations(reactiveTransactionOperations, coroutineTxHelper);
    }

    @EachBean(value=NamedMongoConfiguration.class)
    <T> AsyncTransactionOperations<T> buildAsyncTransactionOperations(@Parameter ReactorReactiveTransactionOperations<T> reactiveTransactionOperations, @Nullable CoroutineTxHelper coroutineTxHelper, @Named(value="io") ExecutorService executorService) {
        return new AsyncUsingReactiveTransactionOperations(reactiveTransactionOperations, coroutineTxHelper);
    }
}

