/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.conf;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;

@ConfigurationProperties(value="micronaut.data.mongodb")
public final class MongoDataConfiguration {
    public static final String PREFIX = "micronaut.data.mongodb";
    public static final String CREATE_COLLECTIONS_PROPERTY = "micronaut.data.mongodb.create-collections";
    public static final String DRIVER_TYPE_PROPERTY = "micronaut.data.mongodb.driver-type";
    public static final String DRIVER_TYPE_SYNC = DriverType.SYNC.name();
    public static final String DRIVER_TYPE_REACTIVE = DriverType.REACTIVE.name();
    public static final String DATABASE_CONFIGURATION_ERROR_MESSAGE = "MongoDB database name is not specified in the url! You can specify it as '@MongoRepository(database: \"mydb\")' or in the connect url: 'mongodb://username:password@localhost:27017/mydb'.";
    private boolean createCollections;
    private DriverType driverType;

    public boolean isCreateCollections() {
        return this.createCollections;
    }

    public void setCreateCollections(boolean createCollections) {
        this.createCollections = createCollections;
    }

    public DriverType getDriverType() {
        return this.driverType;
    }

    public void setDriverType(DriverType driverType) {
        this.driverType = driverType;
    }

    public static final class NotSyncDriverSelectedCondition
    implements Condition {
        public boolean matches(ConditionContext context) {
            return ((MongoDataConfiguration)context.getBean(MongoDataConfiguration.class)).driverType != DriverType.SYNC;
        }
    }

    public static final class NotReactiveDriverSelectedCondition
    implements Condition {
        public boolean matches(ConditionContext context) {
            return ((MongoDataConfiguration)context.getBean(MongoDataConfiguration.class)).driverType != DriverType.REACTIVE;
        }
    }

    public static enum DriverType {
        SYNC,
        REACTIVE;

    }
}

