/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.operations;

import com.mongodb.client.model.Collation;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.UpdateOptions;
import io.micronaut.aop.InvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.runtime.AttributeConverterRegistry;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.model.runtime.convert.AttributeConverter;
import io.micronaut.data.mongodb.annotation.MongoCollation;
import io.micronaut.data.mongodb.annotation.MongoProjection;
import io.micronaut.data.mongodb.annotation.MongoSort;
import io.micronaut.data.mongodb.operations.MongoAggregation;
import io.micronaut.data.mongodb.operations.MongoDelete;
import io.micronaut.data.mongodb.operations.MongoFind;
import io.micronaut.data.mongodb.operations.MongoStoredQuery;
import io.micronaut.data.mongodb.operations.MongoUpdate;
import io.micronaut.data.mongodb.operations.MongoUtils;
import io.micronaut.data.mongodb.operations.options.MongoAggregationOptions;
import io.micronaut.data.mongodb.operations.options.MongoFindOptions;
import io.micronaut.data.mongodb.operations.options.MongoOptionsUtils;
import io.micronaut.data.runtime.query.internal.DefaultStoredQuery;
import io.micronaut.data.runtime.query.internal.DelegateStoredQuery;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonObjectId;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

@Internal
final class DefaultMongoStoredQuery<E, R, Dtb>
implements DelegateStoredQuery<E, R>,
MongoStoredQuery<E, R, Dtb> {
    private static final BsonDocument EMPTY = new BsonDocument();
    private final StoredQuery<E, R> storedQuery;
    private final CodecRegistry codecRegistry;
    private final AttributeConverterRegistry attributeConverterRegistry;
    private final RuntimeEntityRegistry runtimeEntityRegistry;
    private final ConversionService<?> conversionService;
    private final Dtb database;
    private final RuntimePersistentEntity<E> persistentEntity;
    private final UpdateData updateData;
    private final FindData findData;
    private final AggregateData aggregateData;
    private final DeleteData deleteData;
    private final boolean isCount;

    DefaultMongoStoredQuery(StoredQuery<E, R> storedQuery, CodecRegistry codecRegistry, AttributeConverterRegistry attributeConverterRegistry, RuntimeEntityRegistry runtimeEntityRegistry, ConversionService<?> conversionService, RuntimePersistentEntity<E> persistentEntity, Dtb database) {
        this(storedQuery, codecRegistry, attributeConverterRegistry, runtimeEntityRegistry, conversionService, persistentEntity, database, (DataMethod.OperationType)storedQuery.getAnnotationMetadata().enumValue(DataMethod.NAME, "opType", DataMethod.OperationType.class).orElseThrow(IllegalStateException::new), storedQuery.getAnnotationMetadata().stringValue(Query.class, "update").orElse(null));
    }

    DefaultMongoStoredQuery(StoredQuery<E, R> storedQuery, CodecRegistry codecRegistry, AttributeConverterRegistry attributeConverterRegistry, RuntimeEntityRegistry runtimeEntityRegistry, ConversionService<?> conversionService, RuntimePersistentEntity<E> persistentEntity, Dtb database, DataMethod.OperationType operationType, String updateJson) {
        String query;
        this.storedQuery = storedQuery;
        this.codecRegistry = codecRegistry;
        this.attributeConverterRegistry = attributeConverterRegistry;
        this.runtimeEntityRegistry = runtimeEntityRegistry;
        this.conversionService = conversionService;
        this.database = database;
        this.persistentEntity = persistentEntity;
        if (operationType == DataMethod.OperationType.QUERY || operationType == DataMethod.OperationType.EXISTS || operationType == DataMethod.OperationType.COUNT) {
            query = storedQuery.getQuery();
            String filterParameter = this.getParameterInRole("filter");
            String filterOptionsParameter = this.getParameterInRole("findOptions");
            String pipelineParameter = this.getParameterInRole("pipeline");
            if (filterParameter != null || filterOptionsParameter != null) {
                this.aggregateData = null;
                this.findData = new FindData(filterParameter, filterOptionsParameter);
            } else if (pipelineParameter != null) {
                this.aggregateData = new AggregateData(pipelineParameter, this.getParameterInRole("aggregateOptions"));
                this.findData = null;
            } else if (StringUtils.isEmpty((CharSequence)query)) {
                this.aggregateData = null;
                this.findData = new FindData((Bson)BsonDocument.parse((String)query));
            } else if (query.startsWith("[")) {
                this.aggregateData = new AggregateData(BsonArray.parse((String)query).stream().map(BsonValue::asDocument).collect(Collectors.toList()));
                this.findData = null;
            } else {
                this.aggregateData = null;
                this.findData = new FindData((Bson)BsonDocument.parse((String)query));
            }
            this.isCount = operationType == DataMethod.OperationType.COUNT || storedQuery.isCount() || query.contains("$count");
        } else {
            this.aggregateData = null;
            this.findData = null;
            this.isCount = false;
        }
        this.deleteData = operationType == DataMethod.OperationType.DELETE ? new DeleteData((Bson)(StringUtils.isEmpty((CharSequence)(query = storedQuery.getQuery())) ? EMPTY : BsonDocument.parse((String)query)), this.getParameterInRole("filter"), this.getParameterInRole("deleteOptions")) : null;
        if (operationType == DataMethod.OperationType.UPDATE) {
            if (StringUtils.isEmpty((CharSequence)updateJson)) {
                throw new IllegalStateException("Update query is expected!");
            }
            query = storedQuery.getQuery();
            this.updateData = new UpdateData((Bson)BsonDocument.parse((String)updateJson), (Bson)(StringUtils.isEmpty((CharSequence)query) ? EMPTY : BsonDocument.parse((String)query)), this.getParameterInRole("filter"), this.getParameterInRole("update"), this.getParameterInRole("updateOptions"));
        } else {
            this.updateData = null;
        }
    }

    public boolean isCount() {
        return this.isCount;
    }

    @Nullable
    private String getParameterInRole(String role) {
        if (this.storedQuery instanceof DefaultStoredQuery) {
            return this.storedQuery.getAnnotationMetadata().getAnnotation(DataMethod.class).stringValue(role).orElse(null);
        }
        return null;
    }

    @Nullable
    private int getParameterIndexByName(@Nullable String name) {
        if (name == null) {
            return -1;
        }
        if (this.storedQuery instanceof DefaultStoredQuery) {
            String[] argumentNames = ((DefaultStoredQuery)this.storedQuery).getMethod().getArgumentNames();
            for (int i = 0; i < argumentNames.length; ++i) {
                String argumentName = argumentNames[i];
                if (!argumentName.equals(name)) continue;
                return i;
            }
            throw new IllegalStateException("Unknown parameter with name: " + name);
        }
        throw new IllegalStateException("Expected DefaultStoredQuery");
    }

    @Nullable
    private <X> X getParameterAtIndex(InvocationContext<?, ?> invocationContext, int index) {
        this.requireInvocationContext(invocationContext);
        return (X)invocationContext.getParameterValues()[index];
    }

    @Override
    public RuntimePersistentEntity<E> getRuntimePersistentEntity() {
        return this.persistentEntity;
    }

    @Override
    public Dtb getDatabase() {
        return this.database;
    }

    @Override
    public boolean isAggregate() {
        return this.aggregateData != null;
    }

    @Override
    public MongoAggregation getAggregation(InvocationContext<?, ?> invocationContext) {
        if (this.aggregateData == null) {
            throw new IllegalStateException("Expected aggregation query!");
        }
        return this.aggregateData.getAggregation(invocationContext);
    }

    @Override
    public MongoFind getFind(InvocationContext<?, ?> invocationContext) {
        if (this.findData == null) {
            throw new IllegalStateException("Expected find query!");
        }
        return this.findData.getFind(invocationContext);
    }

    @Override
    public MongoUpdate getUpdateMany(InvocationContext<?, ?> invocationContext) {
        if (this.updateData == null) {
            throw new IllegalStateException("Expected update query!");
        }
        return this.updateData.getUpdateMany(invocationContext);
    }

    @Override
    public MongoUpdate getUpdateOne(E entity) {
        if (this.updateData == null) {
            throw new IllegalStateException("Expected update query!");
        }
        return this.updateData.getUpdateOne(entity);
    }

    @Override
    public MongoDelete getDeleteMany(InvocationContext<?, ?> invocationContext) {
        if (this.deleteData == null) {
            throw new IllegalStateException("Expected delete query!");
        }
        return this.deleteData.getDeleteMany(invocationContext);
    }

    @Override
    public MongoDelete getDeleteOne(E entity) {
        if (this.deleteData == null) {
            throw new IllegalStateException("Expected delete query!");
        }
        return this.deleteData.getDeleteOne(entity);
    }

    private boolean needsProcessing(Bson value) {
        if (value == null) {
            return false;
        }
        if (value instanceof BsonDocument) {
            return this.needsProcessingValue((BsonValue)value.toBsonDocument());
        }
        throw new IllegalStateException("Unrecognized value: " + value);
    }

    private boolean needsProcessing(List<Bson> values) {
        if (values == null) {
            return false;
        }
        for (Bson value : values) {
            if (!this.needsProcessing(value)) continue;
            return true;
        }
        return false;
    }

    private boolean needsProcessingValue(BsonValue value) {
        if (value instanceof BsonDocument) {
            BsonDocument bsonDocument = (BsonDocument)value;
            BsonInt32 queryParameterIndex = bsonDocument.getInt32((Object)"$mn_qp", null);
            if (queryParameterIndex != null) {
                return true;
            }
            for (Map.Entry entry : bsonDocument.entrySet()) {
                BsonValue bsonValue = (BsonValue)entry.getValue();
                if (!this.needsProcessingValue(bsonValue)) continue;
                return true;
            }
            return false;
        }
        if (value instanceof BsonArray) {
            BsonArray bsonArray = (BsonArray)value;
            for (BsonValue bsonValue : bsonArray) {
                if (!this.needsProcessingValue(bsonValue)) continue;
                return true;
            }
        }
        return false;
    }

    private Bson replaceQueryParameters(Bson value, @Nullable InvocationContext<?, ?> invocationContext, @Nullable E entity) {
        if (value instanceof BsonDocument) {
            return (BsonDocument)this.replaceQueryParametersInBsonValue((BsonValue)((BsonDocument)value).clone(), invocationContext, entity);
        }
        throw new IllegalStateException("Unrecognized value: " + value);
    }

    private <T> List<Bson> replaceQueryParametersInList(List<Bson> values, @Nullable InvocationContext<?, ?> invocationContext, @Nullable E entity) {
        values = new ArrayList<Bson>(values);
        for (int i = 0; i < values.size(); ++i) {
            Bson newValue;
            Bson value = values.get(i);
            if (value == (newValue = this.replaceQueryParameters(value, invocationContext, entity))) continue;
            values.set(i, newValue);
        }
        return values;
    }

    private BsonValue replaceQueryParametersInBsonValue(BsonValue value, @Nullable InvocationContext<?, ?> invocationContext, @Nullable E entity) {
        if (value instanceof BsonDocument) {
            BsonDocument bsonDocument = (BsonDocument)value;
            BsonInt32 queryParameterIndex = bsonDocument.getInt32((Object)"$mn_qp", null);
            if (queryParameterIndex != null) {
                int index = queryParameterIndex.getValue();
                return this.getValue(index, (QueryParameterBinding)this.getQueryBindings().get(index), invocationContext, this.persistentEntity, this.codecRegistry, entity);
            }
            for (Map.Entry entry : bsonDocument.entrySet()) {
                BsonValue newValue;
                BsonValue bsonValue = (BsonValue)entry.getValue();
                if (bsonValue == (newValue = this.replaceQueryParametersInBsonValue(bsonValue, invocationContext, entity))) continue;
                entry.setValue(newValue);
            }
            return bsonDocument;
        }
        if (value instanceof BsonArray) {
            BsonArray bsonArray = (BsonArray)value;
            for (int i = 0; i < bsonArray.size(); ++i) {
                BsonValue newValue;
                BsonValue bsonValue = bsonArray.get(i);
                if (bsonValue == (newValue = this.replaceQueryParametersInBsonValue(bsonValue, invocationContext, entity))) continue;
                if (newValue.isNull()) {
                    bsonArray.remove(i);
                    --i;
                    continue;
                }
                if (newValue.isArray()) {
                    bsonArray.remove(i);
                    List values = newValue.asArray().getValues();
                    bsonArray.addAll(i, (Collection)values);
                    i += values.size() - 1;
                    continue;
                }
                bsonArray.set(i, newValue);
            }
        }
        return value;
    }

    private <QE, QR, T> BsonValue getValue(int index, QueryParameterBinding queryParameterBinding, InvocationContext<?, ?> invocationContext, RuntimePersistentEntity<T> persistentEntity, CodecRegistry codecRegistry, E entity) {
        PersistentPropertyPath pp;
        Object value;
        Class parameterConverter = queryParameterBinding.getParameterConverterClass();
        if (queryParameterBinding.getParameterIndex() != -1) {
            this.requireInvocationContext(invocationContext);
            value = this.resolveParameterValue(queryParameterBinding, invocationContext.getParameterValues());
        } else if (queryParameterBinding.isAutoPopulated()) {
            pp = this.getRequiredPropertyPath(queryParameterBinding, persistentEntity);
            RuntimePersistentProperty persistentProperty = (RuntimePersistentProperty)pp.getProperty();
            Object previousValue = null;
            QueryParameterBinding previousPopulatedValueParameter = queryParameterBinding.getPreviousPopulatedValueParameter();
            if (previousPopulatedValueParameter != null) {
                if (previousPopulatedValueParameter.getParameterIndex() == -1) {
                    throw new IllegalStateException("Previous value parameter cannot be bind!");
                }
                previousValue = this.resolveParameterValue(previousPopulatedValueParameter, invocationContext.getParameterValues());
            }
            value = this.runtimeEntityRegistry.autoPopulateRuntimeProperty(persistentProperty, previousValue);
            value = this.convert(value, persistentProperty);
            parameterConverter = null;
        } else if (entity != null) {
            pp = this.getRequiredPropertyPath(queryParameterBinding, persistentEntity);
            value = pp.getPropertyValue(entity);
        } else {
            throw new IllegalStateException("Invalid query []. Unable to establish parameter value for parameter at position: " + (index + 1));
        }
        DataType dataType = queryParameterBinding.getDataType();
        List<Object> values = this.expandValue(value, dataType);
        if (values != null && values.isEmpty()) {
            value = null;
            values = null;
        }
        if (values == null) {
            if (parameterConverter != null) {
                Argument argument;
                int parameterIndex = queryParameterBinding.getParameterIndex();
                if (parameterIndex > -1) {
                    this.requireInvocationContext(invocationContext);
                    argument = invocationContext.getArguments()[parameterIndex];
                } else {
                    argument = null;
                }
                value = this.convert(parameterConverter, value, argument);
            }
            if (value instanceof String && queryParameterBinding.getPropertyPath() != null) {
                RuntimeAssociation runtimeAssociation;
                RuntimePersistentProperty identity;
                PersistentPropertyPath pp2 = this.getRequiredPropertyPath(queryParameterBinding, persistentEntity);
                RuntimePersistentProperty persistentProperty = (RuntimePersistentProperty)pp2.getProperty();
                if (persistentProperty instanceof RuntimeAssociation && (identity = (runtimeAssociation = (RuntimeAssociation)persistentProperty).getAssociatedEntity().getIdentity()) != null && identity.getType() == String.class && identity.isGenerated()) {
                    return new BsonObjectId(new ObjectId((String)value));
                }
                if (persistentProperty.getOwner().getIdentity() == persistentProperty && persistentProperty.getType() == String.class && persistentProperty.isGenerated()) {
                    return new BsonObjectId(new ObjectId((String)value));
                }
            }
            return MongoUtils.toBsonValue(this.conversionService, value, codecRegistry);
        }
        Class finalParameterConverter = parameterConverter;
        return new BsonArray(values.stream().map(val -> {
            if (finalParameterConverter != null) {
                Argument argument;
                int parameterIndex = queryParameterBinding.getParameterIndex();
                if (parameterIndex > -1) {
                    this.requireInvocationContext(invocationContext);
                    argument = invocationContext.getArguments()[parameterIndex];
                } else {
                    argument = null;
                }
                val = this.convert(finalParameterConverter, val, argument);
            }
            return MongoUtils.toBsonValue(this.conversionService, val, codecRegistry);
        }).collect(Collectors.toList()));
    }

    private void requireInvocationContext(InvocationContext<?, ?> invocationContext) {
        if (invocationContext == null) {
            throw new IllegalStateException("Invocation context is required!");
        }
    }

    private Object convert(Class<?> converterClass, Object value, @Nullable Argument<?> argument) {
        if (converterClass == null) {
            return value;
        }
        AttributeConverter converter = this.attributeConverterRegistry.getConverter(converterClass);
        ConversionContext conversionContext = this.createTypeConversionContext(null, argument);
        return converter.convertToPersistedValue(value, conversionContext);
    }

    private Object convert(Object value, RuntimePersistentProperty<?> property) {
        AttributeConverter converter = property.getConverter();
        if (converter != null) {
            return converter.convertToPersistedValue(value, this.createTypeConversionContext(property, property.getArgument()));
        }
        return value;
    }

    private <T> PersistentPropertyPath getRequiredPropertyPath(QueryParameterBinding queryParameterBinding, RuntimePersistentEntity<T> persistentEntity) {
        CharSequence[] propertyPath = queryParameterBinding.getRequiredPropertyPath();
        PersistentPropertyPath pp = persistentEntity.getPropertyPath((String[])propertyPath);
        if (pp == null) {
            throw new IllegalStateException("Cannot find auto populated property: " + String.join((CharSequence)".", propertyPath));
        }
        return pp;
    }

    private List<Object> expandValue(Object value, DataType dataType) {
        if (value == null || dataType != null && dataType.isArray() && dataType != DataType.BYTE_ARRAY || value instanceof byte[]) {
            return null;
        }
        if (value instanceof Iterable) {
            return CollectionUtils.iterableToList((Iterable)((Iterable)value));
        }
        if (value.getClass().isArray()) {
            int len = Array.getLength(value);
            if (len == 0) {
                return Collections.emptyList();
            }
            ArrayList<Object> list = new ArrayList<Object>(len);
            for (int j = 0; j < len; ++j) {
                Object o = Array.get(value, j);
                list.add(o);
            }
            return list;
        }
        return null;
    }

    private Object resolveParameterValue(QueryParameterBinding queryParameterBinding, Object[] parameterArray) {
        Object value = parameterArray[queryParameterBinding.getParameterIndex()];
        String[] parameterBindingPath = queryParameterBinding.getParameterBindingPath();
        if (parameterBindingPath != null) {
            for (String prop : parameterBindingPath) {
                if (value == null) {
                    return null;
                }
                Object finalValue = value;
                BeanProperty beanProperty = (BeanProperty)BeanIntrospection.getIntrospection(value.getClass()).getProperty(prop).orElseThrow(() -> new IntrospectionException("Cannot find a property: '" + prop + "' on bean: " + finalValue));
                value = beanProperty.get(value);
            }
        }
        return value;
    }

    private ConversionContext createTypeConversionContext(RuntimePersistentProperty<?> property, Argument<?> argument) {
        if (argument != null) {
            return ConversionContext.of(argument);
        }
        return ConversionContext.DEFAULT;
    }

    public StoredQuery<E, R> getStoredQueryDelegate() {
        return this.storedQuery;
    }

    private abstract class CollationSupported {
        private final Bson collationAsBson;
        private final boolean collationNeedsProcessing;
        private final Collation collation;

        protected CollationSupported() {
            this.collationAsBson = DefaultMongoStoredQuery.this.storedQuery.getAnnotationMetadata().stringValue(MongoCollation.class).map(BsonDocument::parse).orElse(null);
            this.collationNeedsProcessing = DefaultMongoStoredQuery.this.needsProcessing(this.collationAsBson);
            this.collation = this.collationAsBson == null || this.collationNeedsProcessing ? null : MongoOptionsUtils.bsonDocumentAsCollation(this.collationAsBson.toBsonDocument());
        }

        protected Collation getCollation(@Nullable InvocationContext<?, ?> invocationContext, @Nullable E entity) {
            if (this.collation != null) {
                return this.collation;
            }
            if (this.collationAsBson == null) {
                return null;
            }
            Bson collationAsBson = this.collationNeedsProcessing ? DefaultMongoStoredQuery.this.replaceQueryParameters(this.collationAsBson, invocationContext, entity) : this.collationAsBson;
            return MongoOptionsUtils.bsonDocumentAsCollation(collationAsBson.toBsonDocument());
        }
    }

    private final class DeleteData
    extends CollationSupported {
        private final Bson filter;
        private final boolean filterNeedsProcessing;
        @Nullable
        private final DeleteOptions options;
        private final int filterParameterIndex;
        private final int optionsParameterIndex;

        private DeleteData(Bson filter, String filterParameter, String optionsParameter) {
            this.filter = filter;
            this.filterNeedsProcessing = DefaultMongoStoredQuery.this.needsProcessing(filter);
            this.filterParameterIndex = DefaultMongoStoredQuery.this.getParameterIndexByName(filterParameter);
            this.optionsParameterIndex = DefaultMongoStoredQuery.this.getParameterIndexByName(optionsParameter);
            this.options = MongoOptionsUtils.buildDeleteOptions(DefaultMongoStoredQuery.this.storedQuery.getAnnotationMetadata(), false).orElse(null);
        }

        public MongoDelete getDeleteMany(InvocationContext<?, ?> invocationContext) {
            DeleteOptions options = this.getOptions(invocationContext);
            return new MongoDelete(this.getFilter(invocationContext, null), options);
        }

        public MongoDelete getDeleteOne(E entity) {
            DeleteOptions options = this.getOptions(null);
            return new MongoDelete(this.getFilter(null, entity), options);
        }

        @NonNull
        private DeleteOptions getOptions(InvocationContext<?, ?> invocationContext) {
            Collation collation;
            DeleteOptions paramOptions;
            DeleteOptions options = this.options;
            if (this.optionsParameterIndex != -1 && (paramOptions = (DeleteOptions)DefaultMongoStoredQuery.this.getParameterAtIndex(invocationContext, this.optionsParameterIndex)) != null) {
                if (options == null) {
                    options = paramOptions;
                } else {
                    options = this.copy(options);
                    this.copyNonNullFrom(options, paramOptions);
                }
            }
            if (options == null) {
                options = new DeleteOptions();
            }
            if ((collation = this.getCollation(invocationContext, null)) != null) {
                if (this.options == options) {
                    options = this.copy(options);
                }
                options.collation(collation);
            }
            return options;
        }

        private DeleteOptions copy(DeleteOptions options) {
            DeleteOptions newOptions = new DeleteOptions();
            newOptions.collation(options.getCollation());
            newOptions.hint(options.getHint());
            newOptions.hintString(options.getHintString());
            return newOptions;
        }

        private void copyNonNullFrom(DeleteOptions to, DeleteOptions from) {
            if (from.getCollation() != null) {
                to.collation(from.getCollation());
            }
            if (from.getHint() != null) {
                to.hint(from.getHint());
            }
            if (from.getHintString() != null) {
                to.hintString(from.getHintString());
            }
        }

        private Bson getFilter(@Nullable InvocationContext<?, ?> invocationContext, E entity) {
            if (this.filterParameterIndex != -1) {
                return (Bson)DefaultMongoStoredQuery.this.getParameterAtIndex(invocationContext, this.filterParameterIndex);
            }
            return this.filterNeedsProcessing ? DefaultMongoStoredQuery.this.replaceQueryParameters(this.filter, invocationContext, entity) : this.filter;
        }
    }

    private final class FindData
    extends CollationSupported {
        private final Bson filter;
        private final boolean filterNeedsProcessing;
        private final Bson sort;
        private final boolean sortNeedsProcessing;
        private final Bson projection;
        private final boolean projectionNeedsProcessing;
        @Nullable
        private final MongoFindOptions options;
        private final int filterParameterIndex;
        private final int optionsParameterIndex;

        private FindData(Bson filter) {
            this(filter, null, null);
        }

        private FindData(String filterParameter, String optionsParameter) {
            this(null, filterParameter, optionsParameter);
        }

        private FindData(Bson filter, String filterParameter, String optionsParameter) {
            this.filterParameterIndex = DefaultMongoStoredQuery.this.getParameterIndexByName(filterParameter);
            this.optionsParameterIndex = DefaultMongoStoredQuery.this.getParameterIndexByName(optionsParameter);
            this.sort = DefaultMongoStoredQuery.this.storedQuery.getAnnotationMetadata().stringValue(MongoSort.class).map(BsonDocument::parse).orElse(null);
            this.sortNeedsProcessing = DefaultMongoStoredQuery.this.needsProcessing(this.sort);
            this.projection = DefaultMongoStoredQuery.this.storedQuery.getAnnotationMetadata().stringValue(MongoProjection.class).map(BsonDocument::parse).orElse(null);
            this.projectionNeedsProcessing = DefaultMongoStoredQuery.this.needsProcessing(this.projection);
            this.filter = filter;
            this.filterNeedsProcessing = DefaultMongoStoredQuery.this.needsProcessing(filter);
            this.options = MongoOptionsUtils.buildFindOptions(DefaultMongoStoredQuery.this.storedQuery.getAnnotationMetadata()).orElse(null);
        }

        public MongoFind getFind(InvocationContext<?, ?> invocationContext) {
            Bson projection;
            Bson sort;
            Collation collation;
            MongoFindOptions options = this.getFilterOptions(invocationContext);
            Bson filter = this.getFilter(invocationContext, null);
            if (filter != null) {
                options.filter(filter);
            }
            if ((collation = this.getCollation(invocationContext, null)) != null) {
                options.collation(collation);
            }
            if ((sort = this.getSort(invocationContext, null)) != null) {
                options.sort(sort);
            }
            if ((projection = this.getProjection(invocationContext, null)) != null) {
                options.projection(projection);
            }
            return new MongoFind(options.isEmpty() ? null : options);
        }

        @NonNull
        private MongoFindOptions getFilterOptions(@Nullable InvocationContext<?, ?> invocationContext) {
            MongoFindOptions paramOptions;
            if (this.optionsParameterIndex != -1 && (paramOptions = (MongoFindOptions)DefaultMongoStoredQuery.this.getParameterAtIndex(invocationContext, this.optionsParameterIndex)) != null) {
                if (this.options == null) {
                    return paramOptions;
                }
                MongoFindOptions options = new MongoFindOptions(this.options);
                options.copyNotNullFrom(paramOptions);
                return options;
            }
            if (this.options != null) {
                return new MongoFindOptions(this.options);
            }
            return new MongoFindOptions();
        }

        private Bson getFilter(@Nullable InvocationContext<?, ?> invocationContext, E entity) {
            if (this.filterParameterIndex != -1) {
                return (Bson)DefaultMongoStoredQuery.this.getParameterAtIndex(invocationContext, this.filterParameterIndex);
            }
            if (this.filter == null) {
                return null;
            }
            return this.filterNeedsProcessing ? DefaultMongoStoredQuery.this.replaceQueryParameters(this.filter, invocationContext, entity) : this.filter;
        }

        private Bson getSort(@Nullable InvocationContext<?, ?> invocationContext, @Nullable E entity) {
            if (this.sort == null) {
                return null;
            }
            return this.sortNeedsProcessing ? DefaultMongoStoredQuery.this.replaceQueryParameters(this.sort, invocationContext, entity) : this.sort;
        }

        private Bson getProjection(@Nullable InvocationContext<?, ?> invocationContext, @Nullable E entity) {
            if (this.projection == null) {
                return null;
            }
            return this.projectionNeedsProcessing ? DefaultMongoStoredQuery.this.replaceQueryParameters(this.projection, invocationContext, entity) : this.projection;
        }
    }

    private final class UpdateData
    extends CollationSupported {
        private final Bson update;
        private final boolean updateNeedsProcessing;
        private final Bson filter;
        private final boolean filterNeedsProcessing;
        @Nullable
        private final UpdateOptions options;
        private final int filterParameterIndex;
        private final int updateParameterIndex;
        private final int optionsParameterIndex;

        private UpdateData(Bson update, Bson filter, String filterParameter, String updateParameter, String optionsParameter) {
            this.update = update;
            this.updateNeedsProcessing = DefaultMongoStoredQuery.this.needsProcessing(update);
            this.filter = filter;
            this.filterNeedsProcessing = DefaultMongoStoredQuery.this.needsProcessing(filter);
            this.filterParameterIndex = DefaultMongoStoredQuery.this.getParameterIndexByName(filterParameter);
            this.updateParameterIndex = DefaultMongoStoredQuery.this.getParameterIndexByName(updateParameter);
            this.optionsParameterIndex = DefaultMongoStoredQuery.this.getParameterIndexByName(optionsParameter);
            this.options = MongoOptionsUtils.buildUpdateOptions(DefaultMongoStoredQuery.this.storedQuery.getAnnotationMetadata(), false).orElse(null);
        }

        private UpdateOptions copy(UpdateOptions options) {
            UpdateOptions newOptions = new UpdateOptions();
            newOptions.collation(options.getCollation());
            newOptions.upsert(options.isUpsert());
            newOptions.bypassDocumentValidation(options.getBypassDocumentValidation());
            newOptions.hint(options.getHint());
            newOptions.hintString(options.getHintString());
            return newOptions;
        }

        private void copyNonNullFrom(UpdateOptions to, UpdateOptions from) {
            if (from.getCollation() != null) {
                to.collation(from.getCollation());
            }
            if (from.isUpsert()) {
                to.upsert(from.isUpsert());
            }
            if (from.getBypassDocumentValidation() != null) {
                to.bypassDocumentValidation(from.getBypassDocumentValidation());
            }
            if (from.getHint() != null) {
                to.hint(from.getHint());
            }
            if (from.getHintString() != null) {
                to.hintString(from.getHintString());
            }
        }

        public MongoUpdate getUpdateMany(InvocationContext<?, ?> invocationContext) {
            return new MongoUpdate(this.getUpdate(invocationContext, null), this.getFilter(invocationContext, null), this.getOptions(invocationContext));
        }

        public MongoUpdate getUpdateOne(E entity) {
            if (DefaultMongoStoredQuery.this.updateData == null) {
                throw new IllegalStateException("Expected update query!");
            }
            Bson update = this.getUpdate(null, entity);
            UpdateOptions options = this.getOptions(null);
            return new MongoUpdate(update, this.getFilter(null, entity), options);
        }

        private Bson getUpdate(InvocationContext<?, ?> invocationContext, E entity) {
            Bson update = this.update;
            if (this.updateParameterIndex != -1) {
                update = (Bson)DefaultMongoStoredQuery.this.getParameterAtIndex(invocationContext, this.updateParameterIndex);
            }
            if (update == null) {
                throw new IllegalStateException("Update query is not provided!");
            }
            Bson bson = update = this.updateNeedsProcessing ? DefaultMongoStoredQuery.this.replaceQueryParameters(update, invocationContext, entity) : update;
            if (update == null) {
                throw new IllegalStateException("Update query is not provided!");
            }
            return update;
        }

        @NonNull
        private UpdateOptions getOptions(InvocationContext<?, ?> invocationContext) {
            Collation collation;
            UpdateOptions paramOptions;
            UpdateOptions options = this.options;
            if (this.optionsParameterIndex != -1 && (paramOptions = (UpdateOptions)DefaultMongoStoredQuery.this.getParameterAtIndex(invocationContext, this.optionsParameterIndex)) != null) {
                if (options == null) {
                    options = paramOptions;
                } else {
                    options = this.copy(this.options);
                    this.copyNonNullFrom(options, paramOptions);
                }
            }
            if (options == null) {
                options = new UpdateOptions();
            }
            if ((collation = this.getCollation(invocationContext, null)) != null) {
                if (options == this.options) {
                    options = this.copy(options);
                }
                options.collation(collation);
            }
            return options;
        }

        private Bson getFilter(@Nullable InvocationContext<?, ?> invocationContext, E entity) {
            if (this.filterParameterIndex != -1) {
                return (Bson)DefaultMongoStoredQuery.this.getParameterAtIndex(invocationContext, this.filterParameterIndex);
            }
            return this.filterNeedsProcessing ? DefaultMongoStoredQuery.this.replaceQueryParameters(this.filter, invocationContext, entity) : this.filter;
        }
    }

    private final class AggregateData
    extends CollationSupported {
        private final List<Bson> pipeline;
        private final boolean pipelineNeedsProcessing;
        @Nullable
        private final MongoAggregationOptions options;
        private final int pipelineParameterIndex;
        private final int optionsParameterIndex;

        private AggregateData(List<Bson> pipeline) {
            this(pipeline, null, null);
        }

        private AggregateData(String pipelineParameter, String optionsParameter) {
            this(null, pipelineParameter, optionsParameter);
        }

        private AggregateData(List<Bson> pipeline, String pipelineParameter, String optionsParameter) {
            this.pipeline = pipeline;
            this.pipelineParameterIndex = DefaultMongoStoredQuery.this.getParameterIndexByName(pipelineParameter);
            this.optionsParameterIndex = DefaultMongoStoredQuery.this.getParameterIndexByName(optionsParameter);
            this.pipelineNeedsProcessing = DefaultMongoStoredQuery.this.needsProcessing(pipeline);
            this.options = MongoOptionsUtils.buildAggregateOptions(DefaultMongoStoredQuery.this.storedQuery.getAnnotationMetadata()).orElse(null);
        }

        public MongoAggregation getAggregation(InvocationContext<?, ?> invocationContext) {
            List<Bson> pipeline = this.getPipeline(invocationContext);
            MongoAggregationOptions options = this.getOptions(invocationContext);
            Collation collation = this.getCollation(invocationContext, null);
            if (collation != null) {
                if (options == null) {
                    options = new MongoAggregationOptions();
                }
                options.collation(collation);
            }
            return new MongoAggregation(pipeline, options);
        }

        private List<Bson> getPipeline(InvocationContext<?, ?> invocationContext) {
            if (this.pipelineParameterIndex != -1) {
                return (List)DefaultMongoStoredQuery.this.getParameterAtIndex(invocationContext, this.pipelineParameterIndex);
            }
            return this.pipelineNeedsProcessing ? DefaultMongoStoredQuery.this.replaceQueryParametersInList(this.pipeline, invocationContext, null) : this.pipeline;
        }

        @Nullable
        private MongoAggregationOptions getOptions(InvocationContext<?, ?> invocationContext) {
            if (this.optionsParameterIndex != -1) {
                MongoAggregationOptions paramOptions = (MongoAggregationOptions)DefaultMongoStoredQuery.this.getParameterAtIndex(invocationContext, this.optionsParameterIndex);
                if (this.options == null) {
                    return paramOptions;
                }
                if (paramOptions != null) {
                    MongoAggregationOptions options = new MongoAggregationOptions(this.options);
                    options.copyNotNullFrom(paramOptions);
                    return options;
                }
            }
            return this.options;
        }
    }
}

