/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.mongodb.operations;

import com.mongodb.client.model.Sorts;
import io.micronaut.aop.InvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.mongodb.operations.DelegatePreparedQuery;
import io.micronaut.data.mongodb.operations.MongoAggregation;
import io.micronaut.data.mongodb.operations.MongoDelete;
import io.micronaut.data.mongodb.operations.MongoFind;
import io.micronaut.data.mongodb.operations.MongoPreparedQuery;
import io.micronaut.data.mongodb.operations.MongoStoredQuery;
import io.micronaut.data.mongodb.operations.MongoUpdate;
import io.micronaut.data.mongodb.operations.options.MongoFindOptions;
import io.micronaut.data.runtime.query.internal.DefaultPreparedQuery;
import io.micronaut.data.runtime.query.internal.DelegateStoredQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

@Internal
final class DefaultMongoPreparedQuery<E, R, Dtb>
implements DelegatePreparedQuery<E, R>,
MongoPreparedQuery<E, R, Dtb> {
    private final DefaultPreparedQuery<E, R> preparedQuery;
    private final MongoStoredQuery<E, R, Dtb> mongoStoredQuery;

    public DefaultMongoPreparedQuery(PreparedQuery<E, R> preparedQuery) {
        this.preparedQuery = (DefaultPreparedQuery)preparedQuery;
        this.mongoStoredQuery = (MongoStoredQuery)((DelegateStoredQuery)preparedQuery).getStoredQueryDelegate();
    }

    @Override
    public RuntimePersistentEntity<E> getRuntimePersistentEntity() {
        return this.mongoStoredQuery.getRuntimePersistentEntity();
    }

    @Override
    public Dtb getDatabase() {
        return this.mongoStoredQuery.getDatabase();
    }

    @Override
    public boolean isAggregate() {
        return this.mongoStoredQuery.isAggregate();
    }

    @Override
    public MongoAggregation getAggregation() {
        MongoAggregation aggregation = this.mongoStoredQuery.getAggregation((InvocationContext<?, ?>)this.preparedQuery.getContext());
        Pageable pageable = this.getPageable();
        if (pageable != Pageable.UNPAGED) {
            ArrayList<Bson> pipeline = new ArrayList<Bson>(aggregation.getPipeline());
            this.applyPageable(pageable, pipeline);
            return new MongoAggregation(pipeline, aggregation.getOptions());
        }
        return aggregation;
    }

    @Override
    public MongoFind getFind() {
        MongoFind find = this.mongoStoredQuery.getFind((InvocationContext<?, ?>)this.preparedQuery.getContext());
        Pageable pageable = this.preparedQuery.getPageable();
        if (pageable != Pageable.UNPAGED) {
            MongoFindOptions findOptions = find.getOptions();
            MongoFindOptions options = findOptions == null ? new MongoFindOptions() : new MongoFindOptions(findOptions);
            options.limit(pageable.getSize()).skip((int)pageable.getOffset());
            Sort pageableSort = pageable.getSort();
            if (pageableSort.isSorted()) {
                Bson sort = pageableSort.getOrderBy().stream().map(order -> order.isAscending() ? Sorts.ascending((String[])new String[]{order.getProperty()}) : Sorts.descending((String[])new String[]{order.getProperty()})).collect(Collectors.collectingAndThen(Collectors.toList(), Sorts::orderBy));
                options.sort(sort);
            }
            return new MongoFind(options);
        }
        return find;
    }

    @Override
    public MongoUpdate getUpdateMany() {
        return this.mongoStoredQuery.getUpdateMany((InvocationContext<?, ?>)this.preparedQuery.getContext());
    }

    @Override
    public MongoDelete getDeleteMany() {
        return this.mongoStoredQuery.getDeleteMany((InvocationContext<?, ?>)this.preparedQuery.getContext());
    }

    @Override
    public PreparedQuery<E, R> getPreparedQueryDelegate() {
        return this.preparedQuery;
    }

    private int applyPageable(Pageable pageable, List<Bson> pipeline) {
        int limit = 0;
        if (pageable != Pageable.UNPAGED) {
            int skip = (int)pageable.getOffset();
            limit = pageable.getSize();
            Sort pageableSort = pageable.getSort();
            if (pageableSort.isSorted()) {
                Bson sort = pageableSort.getOrderBy().stream().map(order -> order.isAscending() ? Sorts.ascending((String[])new String[]{order.getProperty()}) : Sorts.descending((String[])new String[]{order.getProperty()})).collect(Collectors.collectingAndThen(Collectors.toList(), Sorts::orderBy));
                BsonDocument sortStage = new BsonDocument().append("$sort", (BsonValue)sort.toBsonDocument());
                this.addStageToPipelineBefore(pipeline, sortStage, "$limit", "$skip");
            }
            if (skip > 0) {
                pipeline.add((Bson)new BsonDocument().append("$skip", (BsonValue)new BsonInt32(skip)));
            }
            if (limit > 0) {
                pipeline.add((Bson)new BsonDocument().append("$limit", (BsonValue)new BsonInt32(limit)));
            }
        }
        return limit;
    }

    private void addStageToPipelineBefore(List<Bson> pipeline, BsonDocument stageToAdd, String ... beforeStages) {
        int lastFoundIndex = -1;
        int index = 0;
        for (Bson stage : pipeline) {
            for (String beforeStageName : beforeStages) {
                if (!stage.toBsonDocument().containsKey((Object)beforeStageName)) continue;
                lastFoundIndex = index;
                break;
            }
            ++index;
        }
        if (lastFoundIndex > -1) {
            pipeline.add(lastFoundIndex, (Bson)stageToAdd);
        } else {
            pipeline.add((Bson)stageToAdd);
        }
    }
}

