/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryBuilder2;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.model.query.builder.jpa.JpaQueryBuilder;
import io.micronaut.data.model.query.builder.jpa.JpaQueryBuilder2;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder2;

@Internal
public interface QueryResultPersistentEntityCriteriaQuery {
    public static QueryBuilder2 findQueryBuilder2(QueryBuilder queryBuilder) {
        Class<?> queryBuilderClass = queryBuilder.getClass();
        if (queryBuilderClass.getSimpleName().equals("CosmosSqlQueryBuilder")) {
            try {
                return (QueryBuilder2)queryBuilderClass.getClassLoader().loadClass("io.micronaut.data.document.model.query.builder.CosmosSqlQueryBuilder2").getDeclaredConstructor(AnnotationMetadata.class).newInstance(((SqlQueryBuilder)queryBuilder).getAnnotationMetadata());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (queryBuilderClass.getSimpleName().equals("MongoQueryBuilder")) {
            try {
                return (QueryBuilder2)queryBuilderClass.getClassLoader().loadClass("io.micronaut.data.document.model.query.builder.MongoQueryBuilder2").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (queryBuilderClass == SqlQueryBuilder.class) {
            return QueryResultPersistentEntityCriteriaQuery.newSqlQueryBuilder((SqlQueryBuilder)queryBuilder);
        }
        if (queryBuilderClass == JpaQueryBuilder.class) {
            return new JpaQueryBuilder2();
        }
        return null;
    }

    public QueryResult buildQuery(AnnotationMetadata var1, QueryBuilder var2);

    public QueryModel getQueryModel();

    default public QueryResult buildCountQuery(AnnotationMetadata annotationMetadata, QueryBuilder queryBuilder) {
        if (queryBuilder.getClass() == SqlQueryBuilder.class) {
            return this.buildCountQuery(annotationMetadata, QueryResultPersistentEntityCriteriaQuery.newSqlQueryBuilder((SqlQueryBuilder)queryBuilder));
        }
        if (queryBuilder.getClass() == JpaQueryBuilder.class) {
            return this.buildCountQuery(annotationMetadata, new JpaQueryBuilder2());
        }
        QueryModel queryModel = this.getQueryModel();
        QueryModel countQuery = QueryModel.from(queryModel.getPersistentEntity());
        countQuery.projections().count();
        QueryModel.Junction junction = queryModel.getCriteria();
        for (QueryModel.Criterion criterion : junction.getCriteria()) {
            countQuery.add(criterion);
        }
        for (JoinPath joinPath : queryModel.getJoinPaths()) {
            Join.Type joinType = joinPath.getJoinType();
            switch (joinType) {
                case INNER: 
                case FETCH: {
                    joinType = Join.Type.DEFAULT;
                    break;
                }
                case LEFT_FETCH: {
                    joinType = Join.Type.LEFT;
                    break;
                }
                case RIGHT_FETCH: {
                    joinType = Join.Type.RIGHT;
                    break;
                }
            }
            countQuery.join(joinPath.getPath(), joinType, null);
        }
        return queryBuilder.buildQuery(annotationMetadata, countQuery);
    }

    public QueryResult buildQuery(AnnotationMetadata var1, QueryBuilder2 var2);

    default public QueryResult buildCountQuery(AnnotationMetadata annotationMetadata, QueryBuilder2 queryBuilder) {
        throw new UnsupportedOperationException();
    }

    private static QueryBuilder2 newSqlQueryBuilder(SqlQueryBuilder sqlQueryBuilder) {
        AnnotationMetadata builderAnnotationMetadata = sqlQueryBuilder.getAnnotationMetadata();
        if (builderAnnotationMetadata == null) {
            return new SqlQueryBuilder2(sqlQueryBuilder.getDialect());
        }
        return new SqlQueryBuilder2(builderAnnotationMetadata);
    }
}

