/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.model.CursoredPageable;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import io.micronaut.serde.annotation.Serdeable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Serdeable
record DefaultCursoredPageable(int size, @Nullable @JsonProperty(value="cursor") Pageable.Cursor currentCursor, Pageable.Mode mode, @JsonProperty(value="number") int page, Sort sort, boolean requestTotal) implements CursoredPageable
{
    @Creator
    DefaultCursoredPageable(int size, @Nullable @JsonProperty(value="cursor") Pageable.Cursor currentCursor, Pageable.Mode mode, @JsonProperty(value="number") int page, Sort sort, boolean requestTotal) {
        if (page < 0) {
            throw new IllegalArgumentException("Page index cannot be negative");
        }
        if (size == 0) {
            throw new IllegalArgumentException("Size cannot be 0");
        }
        if (mode != Pageable.Mode.CURSOR_NEXT && mode != Pageable.Mode.CURSOR_PREVIOUS) {
            throw new IllegalArgumentException("The pagination mode must be either currentCursor forward or currentCursor backward");
        }
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public Optional<Pageable.Cursor> cursor() {
        return Optional.ofNullable(this.currentCursor);
    }

    @Override
    public int getNumber() {
        return this.page;
    }

    @Override
    @NonNull
    public Sort getSort() {
        return this.sort;
    }

    @Override
    public boolean isBackward() {
        return this.mode == Pageable.Mode.CURSOR_PREVIOUS;
    }

    @Override
    public CursoredPageable next() {
        throw new UnsupportedOperationException("To get next pageable results must be retrieved. Use page.nextPageable() to retrieve the next pageable.");
    }

    @Override
    public CursoredPageable previous() {
        throw new UnsupportedOperationException("To get next pageable results must be retrieved. Use page.nextPageable() to retrieve the next pageable.");
    }

    @Override
    public Pageable withTotal() {
        if (this.requestTotal) {
            return this;
        }
        return new DefaultCursoredPageable(this.size, this.currentCursor, this.mode, this.page, this.sort, true);
    }

    @Override
    public Pageable withoutTotal() {
        if (!this.requestTotal) {
            return this;
        }
        return new DefaultCursoredPageable(this.size, this.currentCursor, this.mode, this.page, this.sort, true);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultCursoredPageable)) {
            return false;
        }
        DefaultCursoredPageable that = (DefaultCursoredPageable)o;
        return this.size == that.size && Objects.equals(this.currentCursor, that.currentCursor) && Objects.equals((Object)this.mode, (Object)that.mode) && Objects.equals(this.sort, that.sort);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.size, this.currentCursor, this.mode, this.sort});
    }

    @Override
    public String toString() {
        return "DefaultCursoredPageable{size=" + this.size + ", page=" + this.page + ", currentCursor=" + this.currentCursor + ", mode=" + this.mode + ", sort=" + this.sort + "}";
    }

    @Serdeable
    record DefaultCursor(List<Object> elements) implements Pageable.Cursor
    {
        @Override
        public Object get(int index) {
            return this.elements.get(index);
        }

        @Override
        public int size() {
            return this.elements.size();
        }
    }
}

