/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.intercept;

import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.ExecutableMethod;
import java.util.Objects;

@Internal
public final class RepositoryMethodKey {
    private final Object repository;
    private final ExecutableMethod<?, ?> method;
    private final int hashCode;

    public RepositoryMethodKey(Object repository, ExecutableMethod<?, ?> method) {
        this.repository = repository;
        this.method = method;
        this.hashCode = Objects.hash(repository, method);
    }

    public Object repository() {
        return this.repository;
    }

    public ExecutableMethod<?, ?> method() {
        return this.method;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RepositoryMethodKey that = (RepositoryMethodKey)obj;
        return Objects.equals(this.repository, that.repository) && Objects.equals(this.method, that.method);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

