/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.naming;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.data.model.naming.NamingStrategy;
import java.util.Locale;

public class NamingStrategies {

    @TypeHint(value={Raw.class})
    public static class Raw
    implements NamingStrategy {
        @Override
        @NonNull
        public String mappedName(@NonNull String name) {
            return name;
        }
    }

    @TypeHint(value={UpperCase.class})
    public static class UpperCase
    implements NamingStrategy {
        @Override
        @NonNull
        public String mappedName(@NonNull String name) {
            return name.toUpperCase(Locale.ENGLISH);
        }
    }

    @TypeHint(value={LowerCase.class})
    public static class LowerCase
    implements NamingStrategy {
        @Override
        @NonNull
        public String mappedName(@NonNull String name) {
            return name.toLowerCase(Locale.ENGLISH);
        }
    }

    @TypeHint(value={KebabCase.class})
    public static class KebabCase
    implements NamingStrategy {
        @Override
        @NonNull
        public String mappedName(@NonNull String name) {
            return NameUtils.hyphenate((String)name);
        }
    }

    @TypeHint(value={UnderScoreSeparatedLowerCase.class})
    public static class UnderScoreSeparatedLowerCase
    implements NamingStrategy {
        @Override
        @NonNull
        public String mappedName(@NonNull String name) {
            return NameUtils.underscoreSeparate((String)name).toLowerCase(Locale.ENGLISH);
        }
    }

    @TypeHint(value={UnderScoreSeparatedUpperCase.class})
    public static class UnderScoreSeparatedUpperCase
    implements NamingStrategy {
        @Override
        @NonNull
        public String mappedName(@NonNull String name) {
            return NameUtils.environmentName((String)name);
        }
    }
}

