/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.runtime;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.Named;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.StoredDataOperation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface StoredQuery<E, R>
extends Named,
StoredDataOperation<R> {
    @NonNull
    public Class<E> getRootEntity();

    public boolean hasPageable();

    @NonNull
    public String getQuery();

    @NonNull
    public String[] getExpandableQueryParts();

    public List<QueryParameterBinding> getQueryBindings();

    @NonNull
    public Class<R> getResultType();

    @Override
    @NonNull
    public Argument<R> getResultArgument();

    @NonNull
    public DataType getResultDataType();

    default public boolean isNative() {
        return false;
    }

    default public boolean isProcedure() {
        return false;
    }

    public OperationType getOperationType();

    @Deprecated(forRemoval=true)
    public boolean useNumericPlaceholders();

    default public boolean isDtoProjection() {
        return false;
    }

    @Deprecated(forRemoval=true)
    default public Optional<Class<?>> getEntityIdentifierType() {
        return Optional.empty();
    }

    @Deprecated(forRemoval=true)
    @NonNull
    default public Class<?>[] getArgumentTypes() {
        return ReflectionUtils.EMPTY_CLASS_ARRAY;
    }

    public boolean isCount();

    @NonNull
    default public Map<String, Object> getQueryHints() {
        return Collections.emptyMap();
    }

    @NonNull
    default public Set<JoinPath> getJoinFetchPaths() {
        return Collections.emptySet();
    }

    @Deprecated(forRemoval=true)
    public boolean isSingleResult();

    public boolean hasResultConsumer();

    default public boolean isOptimisticLock() {
        return false;
    }

    public boolean isRawQuery();

    default public boolean isJsonEntity() {
        return false;
    }

    public static enum OperationType {
        QUERY,
        COUNT,
        EXISTS,
        UPDATE,
        UPDATE_RETURNING,
        DELETE,
        DELETE_RETURNING,
        INSERT,
        INSERT_RETURNING;

    }
}

