/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.builder;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import io.micronaut.data.model.jpa.criteria.impl.DefaultOrder;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.builder.QueryResult;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Internal
@Introspected
public interface QueryBuilder2 {
    @Nullable
    public QueryResult buildInsert(AnnotationMetadata var1, InsertQueryDefinition var2);

    public QueryResult buildSelect(@NonNull AnnotationMetadata var1, @NonNull SelectQueryDefinition var2);

    public QueryResult buildUpdate(@NonNull AnnotationMetadata var1, @NonNull UpdateQueryDefinition var2);

    public QueryResult buildDelete(@NonNull AnnotationMetadata var1, @NonNull DeleteQueryDefinition var2);

    @NonNull
    public String buildLimitAndOffset(long var1, long var3);

    public static interface BaseQueryDefinition {
        @NonNull
        public PersistentEntity persistentEntity();

        @Nullable
        public Predicate predicate();

        public Collection<JoinPath> getJoinPaths();

        public Optional<JoinPath> getJoinPath(String var1);

        default public int limit() {
            return -1;
        }

        default public int offset() {
            return -1;
        }
    }

    public static interface UpdateQueryDefinition
    extends BaseQueryDefinition {
        @NonNull
        public Map<String, Object> propertiesToUpdate();

        @Nullable
        public Selection<?> returningSelection();
    }

    public static interface InsertQueryDefinition {
        @NonNull
        public PersistentEntity persistentEntity();

        @Nullable
        public Selection<?> returningSelection();
    }

    public static interface DeleteQueryDefinition
    extends BaseQueryDefinition {
        @Nullable
        public Selection<?> returningSelection();
    }

    public static interface SelectQueryDefinition
    extends BaseQueryDefinition {
        @NonNull
        public Root<?> root();

        @NonNull
        public Selection<?> selection();

        @NonNull
        public List<Order> order();

        default public Sort asSort() {
            List<Order> orders = this.order();
            if (orders == null || orders.isEmpty()) {
                return Sort.unsorted();
            }
            List<Sort.Order> sortOrders = orders.stream().map(o -> {
                PersistentPropertyPath propertyPath = CriteriaUtils.requireProperty(o.getExpression());
                String name = propertyPath.getPathAsString();
                if (o instanceof DefaultOrder) {
                    DefaultOrder order = (DefaultOrder)o;
                    return new Sort.Order(name, order.isAscending() ? Sort.Order.Direction.ASC : Sort.Order.Direction.DESC, order.isIgnoreCase());
                }
                if (o.isAscending()) {
                    return Sort.Order.asc(name);
                }
                return Sort.Order.desc(name);
            }).toList();
            return Sort.of(sortOrders);
        }

        default public boolean isForUpdate() {
            return false;
        }

        default public boolean isDistinct() {
            return false;
        }

        default public Map<Integer, String> parametersInRole() {
            return Map.of();
        }
    }
}

