/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl.expression;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import jakarta.persistence.criteria.Expression;

@Internal
public enum UnaryExpressionType {
    AVG,
    SUM,
    MAX,
    MIN,
    COUNT,
    COUNT_DISTINCT,
    UPPER,
    LOWER,
    LENGTH;


    void validate(Expression<?> expression) {
        switch (this.ordinal()) {
            case 0: 
            case 1: {
                CriteriaUtils.requireNumericExpression(expression);
                break;
            }
            case 2: 
            case 3: {
                CriteriaUtils.requireComparableExpression(expression);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                CriteriaUtils.requireStringExpression(expression);
                break;
            }
            case 4: 
            case 5: {
                CriteriaUtils.requirePropertyOrRoot(expression);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this));
            }
        }
    }
}

