/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.jpa.criteria.IPredicate;
import io.micronaut.data.model.jpa.criteria.ISelection;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.impl.query.QueryModelPredicateVisitor;
import io.micronaut.data.model.jpa.criteria.impl.query.QueryModelSelectionVisitor;
import io.micronaut.data.model.jpa.criteria.impl.util.Joiner;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryBuilder2;
import io.micronaut.data.model.query.builder.QueryResult;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Selection;
import java.util.Map;
import java.util.Optional;

@Internal
final class LegacyQueryModelQueryBuilder
implements QueryBuilder2 {
    private final QueryBuilder queryBuilder;

    LegacyQueryModelQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    @NonNull
    private QueryModelPredicateVisitor createPredicateVisitor(QueryModel queryModel) {
        return new QueryModelPredicateVisitor(queryModel);
    }

    @Override
    public QueryResult buildInsert(AnnotationMetadata repositoryMetadata, QueryBuilder2.InsertQueryDefinition definition) {
        throw new IllegalStateException("Not supported");
    }

    @Override
    public QueryResult buildSelect(AnnotationMetadata annotationMetadata, QueryBuilder2.SelectQueryDefinition definition) {
        QueryModel qm = QueryModel.from(definition.persistentEntity());
        Joiner joiner = new Joiner();
        Predicate predicate = definition.predicate();
        if (predicate instanceof IPredicate) {
            IPredicate predicateVisitable = (IPredicate)predicate;
            predicateVisitable.visitPredicate(this.createPredicateVisitor(qm));
            predicateVisitable.visitPredicate(joiner);
        }
        PersistentEntityRoot entityRoot = (PersistentEntityRoot)definition.root();
        Selection<?> selection = definition.selection();
        if (selection instanceof ISelection) {
            ISelection selectionVisitable = (ISelection)selection;
            selectionVisitable.visitSelection(new QueryModelSelectionVisitor(qm, definition.isDistinct()));
            selectionVisitable.visitSelection(joiner);
            entityRoot.visitSelection(joiner);
        } else {
            entityRoot.visitSelection(new QueryModelSelectionVisitor(qm, definition.isDistinct()));
            entityRoot.visitSelection(joiner);
        }
        Sort sort = definition.asSort();
        if (sort.isSorted()) {
            qm.sort(sort);
        }
        for (Map.Entry entry : joiner.getJoins().entrySet()) {
            qm.join((String)entry.getKey(), Optional.ofNullable(((Joiner.Joined)entry.getValue()).getType()).orElse(Join.Type.DEFAULT), ((Joiner.Joined)entry.getValue()).getAlias());
        }
        qm.max(definition.limit());
        qm.offset(definition.offset());
        if (definition.isForUpdate()) {
            qm.forUpdate();
        }
        return this.queryBuilder.buildQuery(annotationMetadata, qm);
    }

    @Override
    public QueryResult buildUpdate(AnnotationMetadata annotationMetadata, QueryBuilder2.UpdateQueryDefinition definition) {
        QueryModel qm = QueryModel.from(definition.persistentEntity());
        Joiner joiner = new Joiner();
        Selection<?> selection = definition.predicate();
        if (selection instanceof IPredicate) {
            IPredicate predicateVisitable = (IPredicate)selection;
            predicateVisitable.visitPredicate(this.createPredicateVisitor(qm));
            predicateVisitable.visitPredicate(joiner);
        }
        if ((selection = definition.returningSelection()) instanceof ISelection) {
            ISelection selectionVisitable = (ISelection)selection;
            selectionVisitable.visitSelection(new QueryModelSelectionVisitor(qm, false));
            selectionVisitable.visitSelection(joiner);
        }
        for (Map.Entry<String, Joiner.Joined> e : joiner.getJoins().entrySet()) {
            qm.join(e.getKey(), Optional.ofNullable(e.getValue().getType()).orElse(Join.Type.DEFAULT), e.getValue().getAlias());
        }
        return this.queryBuilder.buildUpdate(qm, definition.propertiesToUpdate());
    }

    @Override
    public QueryResult buildDelete(AnnotationMetadata annotationMetadata, QueryBuilder2.DeleteQueryDefinition definition) {
        if (definition.persistentEntity() == null) {
            throw new IllegalStateException("The root entity must be specified!");
        }
        QueryModel qm = QueryModel.from(definition.persistentEntity());
        Joiner joiner = new Joiner();
        Selection<?> selection = definition.predicate();
        if (selection instanceof IPredicate) {
            IPredicate predicateVisitable = (IPredicate)selection;
            predicateVisitable.visitPredicate(this.createPredicateVisitor(qm));
            predicateVisitable.visitPredicate(joiner);
        }
        if ((selection = definition.returningSelection()) instanceof ISelection) {
            ISelection selectionVisitable = (ISelection)selection;
            selectionVisitable.visitSelection(new QueryModelSelectionVisitor(qm, false));
            selectionVisitable.visitSelection(joiner);
        }
        for (Map.Entry<String, Joiner.Joined> e : joiner.getJoins().entrySet()) {
            qm.join(e.getKey(), Optional.ofNullable(e.getValue().getType()).orElse(Join.Type.DEFAULT), e.getValue().getAlias());
        }
        return this.queryBuilder.buildDelete(qm);
    }

    @Override
    public String buildLimitAndOffset(long limit, long offset) {
        throw new IllegalStateException("Not supported");
    }
}

