/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model;

import io.micronaut.core.annotation.Internal;

public interface Limit {
    public static final Limit UNLIMITED = Limit.of(-1, 0L);

    default public int maxResults() {
        return -1;
    }

    default public long offset() {
        return 0L;
    }

    default public boolean isLimited() {
        return this.maxResults() != -1 || this.offset() > 0L;
    }

    public static Limit of(int maxResults, long offset) {
        return new DefaultLimit(maxResults, offset);
    }

    @Internal
    public record DefaultLimit(int maxResults, long offset) implements Limit
    {
    }
}

