/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.intercept;

import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.ExecutableMethod;
import java.util.Objects;

@Internal
public final class RepositoryMethodKey {
    private final Class<?> repositoryClass;
    private final ExecutableMethod<?, ?> method;
    private final int hashCode;

    public RepositoryMethodKey(Object repository, ExecutableMethod<?, ?> method) {
        this.repositoryClass = repository.getClass();
        this.method = method;
        this.hashCode = Objects.hash(this.repositoryClass, method.getName(), method.getArguments().length);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryMethodKey that = (RepositoryMethodKey)o;
        return Objects.equals(this.repositoryClass, that.repositoryClass) && Objects.equals(this.method, that.method);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

