/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl.query;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.jpa.criteria.IExpression;
import io.micronaut.data.model.jpa.criteria.IPredicate;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import io.micronaut.data.model.jpa.criteria.impl.PredicateVisitor;
import io.micronaut.data.model.jpa.criteria.impl.expression.IdExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.LiteralExpression;
import io.micronaut.data.model.jpa.criteria.impl.predicate.BetweenPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.BinaryPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.ConjunctionPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.DisjunctionPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.ExistsSubqueryPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.InPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.LikePredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.NegatedPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.PredicateBinaryOp;
import io.micronaut.data.model.jpa.criteria.impl.predicate.UnaryPredicate;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.factory.Restrictions;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.ParameterExpression;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;

@Internal
public final class QueryModelPredicateVisitor
implements PredicateVisitor {
    private final QueryModel queryModel;
    private State state = new State();

    public QueryModelPredicateVisitor(QueryModel queryModel) {
        this.queryModel = queryModel;
    }

    private void visit(IExpression<Boolean> expression) {
        if (expression instanceof IPredicate) {
            IPredicate predicateVisitable = (IPredicate)expression;
            predicateVisitable.visitPredicate(this);
        } else if (expression instanceof PersistentPropertyPath) {
            PersistentPropertyPath propertyPath = (PersistentPropertyPath)expression;
            this.add(Restrictions.isTrue(this.getPropertyPath(propertyPath)));
        } else {
            throw new IllegalStateException("Unknown boolean expression: " + String.valueOf(expression));
        }
    }

    @Override
    public void visit(ConjunctionPredicate conjunction) {
        if (conjunction.getPredicates().isEmpty()) {
            return;
        }
        if (conjunction.getPredicates().size() == 1) {
            this.visit(conjunction.getPredicates().iterator().next());
            return;
        }
        if (this.state.junction == null || this.state.junction instanceof QueryModel.Conjunction) {
            for (IExpression<Boolean> iExpression : conjunction.getPredicates()) {
                this.visit(iExpression);
            }
        } else {
            QueryModel.Conjunction junction = new QueryModel.Conjunction();
            State state = this.pushState();
            this.state.junction = junction;
            for (IExpression<Boolean> iExpression : conjunction.getPredicates()) {
                this.visit(iExpression);
            }
            this.restoreState(state);
            this.add(junction);
        }
    }

    @Override
    public void visit(DisjunctionPredicate disjunction) {
        if (disjunction.getPredicates().isEmpty()) {
            return;
        }
        if (disjunction.getPredicates().size() == 1) {
            this.visit(disjunction.getPredicates().iterator().next());
            return;
        }
        QueryModel.Disjunction junction = new QueryModel.Disjunction();
        State prevState = this.pushState();
        this.state.junction = junction;
        for (IExpression<Boolean> iExpression : disjunction.getPredicates()) {
            this.visit(iExpression);
        }
        this.restoreState(prevState);
        this.add(junction);
    }

    @Override
    public void visit(NegatedPredicate negate) {
        State prevState = this.pushState();
        this.state.negated = true;
        this.visit(negate.getNegated());
        this.restoreState(prevState);
    }

    @Override
    public void visit(BinaryPredicate binaryPredicate) {
        PredicateBinaryOp op = binaryPredicate.getOp();
        if (op == PredicateBinaryOp.EQUALS && binaryPredicate.getLeftExpression() instanceof IdExpression) {
            this.add(Restrictions.idEq(this.asValue(binaryPredicate.getRightExpression())));
            return;
        }
        PersistentPropertyPath<?> propertyPath = CriteriaUtils.requireProperty(binaryPredicate.getLeftExpression());
        Expression<?> expression = binaryPredicate.getRightExpression();
        this.visitPropertyPathPredicate(propertyPath, expression, op);
    }

    private void visitPropertyPathPredicate(PersistentPropertyPath<?> propertyPath, Expression<?> expression, PredicateBinaryOp op) {
        if (expression instanceof PersistentPropertyPath) {
            PersistentPropertyPath persistentPropertyPath = (PersistentPropertyPath)expression;
            this.add(this.getPropertyToPropertyRestriction(op, propertyPath, persistentPropertyPath));
        } else if (expression instanceof ParameterExpression) {
            this.add(this.getPropertyToValueRestriction(op, propertyPath, expression));
        } else if (expression instanceof LiteralExpression) {
            LiteralExpression literalExpression = (LiteralExpression)expression;
            this.add(this.getPropertyToValueRestriction(op, propertyPath, literalExpression.getValue()));
        } else {
            throw new IllegalStateException("Unsupported expression: " + String.valueOf(expression));
        }
    }

    private QueryModel.Criterion getPropertyToValueRestriction(PredicateBinaryOp op, PersistentPropertyPath<?> left, Object right) {
        String leftProperty = this.getPropertyPath(left);
        Object rightProperty = this.asValue(right);
        switch (op) {
            case EQUALS: {
                PersistentProperty property = left.getProperty();
                PersistentEntity owner = property.getOwner();
                if (left.getAssociations().isEmpty() && owner.hasIdentity() && owner.getIdentity() == property) {
                    return Restrictions.idEq(rightProperty);
                }
                if (left.getAssociations().isEmpty() && owner.getVersion() == property) {
                    return Restrictions.versionEq(rightProperty);
                }
                return Restrictions.eq(leftProperty, rightProperty);
            }
            case NOT_EQUALS: {
                return Restrictions.ne(leftProperty, rightProperty);
            }
            case GREATER_THAN: {
                return Restrictions.gt(leftProperty, rightProperty);
            }
            case GREATER_THAN_OR_EQUALS: {
                return Restrictions.gte(leftProperty, rightProperty);
            }
            case LESS_THAN: {
                return Restrictions.lt(leftProperty, rightProperty);
            }
            case LESS_THAN_OR_EQUALS: {
                return Restrictions.lte(leftProperty, rightProperty);
            }
            case CONTAINS: {
                return Restrictions.contains(leftProperty, rightProperty);
            }
            case CONTAINS_IGNORE_CASE: {
                return Restrictions.contains(leftProperty, rightProperty).ignoreCase(true);
            }
            case ENDS_WITH: {
                return Restrictions.endsWith(leftProperty, rightProperty);
            }
            case STARTS_WITH: {
                return Restrictions.startsWith(leftProperty, rightProperty);
            }
            case REGEX: {
                return Restrictions.regex(leftProperty, rightProperty);
            }
            case EQUALS_IGNORE_CASE: {
                return Restrictions.eq(leftProperty, rightProperty).ignoreCase(true);
            }
            case NOT_EQUALS_IGNORE_CASE: {
                return Restrictions.ne(leftProperty, rightProperty).ignoreCase(true);
            }
            case STARTS_WITH_IGNORE_CASE: {
                return Restrictions.startsWith(leftProperty, rightProperty).ignoreCase(true);
            }
            case ENDS_WITH_IGNORE_CASE: {
                return Restrictions.endsWith(leftProperty, rightProperty).ignoreCase(true);
            }
            case ARRAY_CONTAINS: {
                return Restrictions.arrayContains(leftProperty, rightProperty);
            }
        }
        throw new IllegalStateException("Unsupported property to value operation: " + String.valueOf((Object)op));
    }

    private QueryModel.Criterion getPropertyToPropertyRestriction(PredicateBinaryOp op, PersistentPropertyPath<?> left, PersistentPropertyPath<?> right) {
        String leftProperty = this.getPropertyPath(left);
        String rightProperty = this.getPropertyPath(right);
        return switch (op) {
            case PredicateBinaryOp.EQUALS -> Restrictions.eqProperty(leftProperty, rightProperty);
            case PredicateBinaryOp.NOT_EQUALS -> Restrictions.neProperty(leftProperty, rightProperty);
            case PredicateBinaryOp.GREATER_THAN -> Restrictions.gtProperty(leftProperty, rightProperty);
            case PredicateBinaryOp.GREATER_THAN_OR_EQUALS -> Restrictions.geProperty(leftProperty, rightProperty);
            case PredicateBinaryOp.LESS_THAN -> Restrictions.ltProperty(leftProperty, rightProperty);
            case PredicateBinaryOp.LESS_THAN_OR_EQUALS -> Restrictions.leProperty(leftProperty, rightProperty);
            default -> throw new IllegalStateException("Unsupported property to property operation: " + String.valueOf((Object)op));
        };
    }

    @Override
    public void visit(UnaryPredicate unaryPredicate) {
        String propertyPath = this.getPropertyPath(CriteriaUtils.requireProperty(unaryPredicate.getExpression()));
        switch (unaryPredicate.getOp()) {
            case IS_NULL: {
                this.add(Restrictions.isNull(propertyPath));
                break;
            }
            case IS_NON_NULL: {
                this.add(Restrictions.isNotNull(propertyPath));
                break;
            }
            case IS_TRUE: {
                this.add(Restrictions.isTrue(propertyPath));
                break;
            }
            case IS_FALSE: {
                this.add(Restrictions.isFalse(propertyPath));
                break;
            }
            case IS_EMPTY: {
                this.add(Restrictions.isEmpty(propertyPath));
                break;
            }
            case IS_NOT_EMPTY: {
                this.add(Restrictions.isNotEmpty(propertyPath));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown op: " + String.valueOf((Object)unaryPredicate.getOp()));
            }
        }
    }

    @Override
    public void visit(BetweenPredicate betweenPredicate) {
        this.add(Restrictions.between(this.getPropertyPath(CriteriaUtils.requireProperty(betweenPredicate.getValue())), this.asValue(betweenPredicate.getFrom()), this.asValue(betweenPredicate.getTo())));
    }

    @Override
    public void visit(InPredicate<?> inPredicate) {
        Iterator iterator;
        Object first;
        List<Expression<?>> values = inPredicate.getValues();
        PersistentPropertyPath<?> persistentPropertyPath = CriteriaUtils.requireProperty(inPredicate.getExpression());
        if (!values.isEmpty() && (first = (iterator = values.iterator()).next()) instanceof ParameterExpression) {
            if (iterator.hasNext()) {
                throw new IllegalStateException("Only one parameter is supported for IN expression!");
            }
            if (this.state.negated) {
                this.state.negated = false;
                this.add(Restrictions.notIn(this.getPropertyPath(persistentPropertyPath), this.asValue(first)));
            } else {
                this.add(Restrictions.in(this.getPropertyPath(persistentPropertyPath), this.asValue(first)));
            }
            return;
        }
        if (this.state.negated) {
            this.state.negated = false;
            this.add(Restrictions.notIn(this.getPropertyPath(persistentPropertyPath), values.stream().map(this::asValue).toList()));
        } else {
            this.add(Restrictions.in(this.getPropertyPath(persistentPropertyPath), values.stream().map(this::asValue).toList()));
        }
    }

    @Override
    public void visit(LikePredicate likePredicate) {
        PersistentPropertyPath<String> propertyPath = CriteriaUtils.requireProperty(likePredicate.getExpression());
        QueryModel.Like criterion = likePredicate.isCaseInsensitive() ? Restrictions.ilike(this.getPropertyPath(propertyPath), likePredicate.getPattern()) : Restrictions.like(this.getPropertyPath(propertyPath), likePredicate.getPattern());
        if (likePredicate.isNegated()) {
            QueryModel.Negation negation = new QueryModel.Negation();
            negation.add(criterion);
            this.add(negation);
        } else {
            this.add(criterion);
        }
    }

    @Override
    public void visit(ExistsSubqueryPredicate existsSubqueryPredicate) {
        throw new UnsupportedOperationException("Exists subquery predicate not supported");
    }

    private Object asValue(Object value) {
        if (value instanceof LiteralExpression) {
            LiteralExpression literalExpression = (LiteralExpression)value;
            return literalExpression.getValue();
        }
        return value;
    }

    private String getPropertyPath(PersistentPropertyPath<?> propertyPath) {
        return this.asPath(propertyPath.getAssociations(), propertyPath.getProperty());
    }

    private String asPath(List<Association> associations, PersistentProperty property) {
        if (associations.isEmpty()) {
            return property.getName();
        }
        StringJoiner joiner = new StringJoiner(".");
        for (Association association : associations) {
            joiner.add(association.getName());
        }
        joiner.add(property.getName());
        return joiner.toString();
    }

    private void add(QueryModel.Criterion criterion) {
        if (this.state.negated) {
            QueryModel.Negation negation = new QueryModel.Negation();
            negation.add(criterion);
            criterion = negation;
        }
        if (this.state.junction == null) {
            this.queryModel.add(criterion);
        } else {
            this.state.junction.add(criterion);
        }
    }

    private State pushState() {
        State prevState = this.state;
        State newState = new State();
        newState.junction = prevState.junction;
        newState.negated = prevState.negated;
        this.state = newState;
        return prevState;
    }

    private State restoreState(State state) {
        State oldState = this.state;
        this.state = state;
        return oldState;
    }

    private static final class State {
        boolean negated;
        QueryModel.Junction junction;

        private State() {
        }
    }
}

