/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl.expression;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.jpa.criteria.ExpressionType;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;

@Internal
public final class ClassExpressionType<E>
implements ExpressionType<E> {
    private final Class<E> expressionType;

    public ClassExpressionType(Class<E> expressionType) {
        this.expressionType = expressionType;
    }

    @Override
    public String getName() {
        return this.expressionType.getName();
    }

    @Override
    public boolean isBoolean() {
        if (this.expressionType != null) {
            return CriteriaUtils.isBoolean(this.expressionType);
        }
        return false;
    }

    @Override
    public boolean isNumeric() {
        if (this.expressionType != null) {
            return CriteriaUtils.isNumeric(this.expressionType);
        }
        return true;
    }

    @Override
    public boolean isComparable() {
        if (this.expressionType != null) {
            return CriteriaUtils.isComparable(this.expressionType);
        }
        return false;
    }

    @Override
    public boolean isTextual() {
        if (this.expressionType != null) {
            return CriteriaUtils.isTextual(this.expressionType);
        }
        return false;
    }

    @Override
    public Class<E> getJavaType() {
        return this.expressionType;
    }
}

