/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl.util;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.PersistentEntityUtils;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.jpa.criteria.IExpression;
import io.micronaut.data.model.jpa.criteria.IPredicate;
import io.micronaut.data.model.jpa.criteria.ISelection;
import io.micronaut.data.model.jpa.criteria.PersistentAssociationPath;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.PersistentEntitySubquery;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.PredicateVisitor;
import io.micronaut.data.model.jpa.criteria.impl.SelectionVisitor;
import io.micronaut.data.model.jpa.criteria.impl.expression.BinaryExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.FunctionExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.IdExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.LiteralExpression;
import io.micronaut.data.model.jpa.criteria.impl.expression.UnaryExpression;
import io.micronaut.data.model.jpa.criteria.impl.predicate.BetweenPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.BinaryPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.ConjunctionPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.DisjunctionPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.ExistsSubqueryPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.InPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.LikePredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.NegatedPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.UnaryPredicate;
import io.micronaut.data.model.jpa.criteria.impl.selection.AliasedSelection;
import io.micronaut.data.model.jpa.criteria.impl.selection.CompoundSelection;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Selection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

@Internal
public class Joiner
implements SelectionVisitor,
PredicateVisitor {
    private final Map<String, Joined> joins = new TreeMap<String, Joined>(Comparator.comparingInt(String::length).thenComparing(String::compareTo));

    public Map<String, Joined> getJoins() {
        return this.joins;
    }

    public void joinIfNeeded(PersistentPropertyPath<?> persistentPropertyPath) {
        this.joinIfNeeded(persistentPropertyPath, false);
    }

    private void joinIfNeeded(PersistentPropertyPath<?> persistentPropertyPath, boolean isPredicate) {
        PersistentProperty property = persistentPropertyPath.getProperty();
        if (isPredicate && property instanceof Association) {
            return;
        }
        this.joinAssociation(persistentPropertyPath);
    }

    private void joinAssociation(Path<?> path) {
        if (path instanceof PersistentAssociationPath) {
            PersistentAssociationPath associationPath = (PersistentAssociationPath)path;
            if (associationPath.getAssociation().getKind() == Relation.Kind.EMBEDDED) {
                this.joinAssociation(path.getParentPath());
            } else {
                this.join(associationPath);
            }
        } else if (path instanceof PersistentPropertyPath) {
            PersistentAssociationPath parent;
            PersistentPropertyPath persistentPropertyPath = (PersistentPropertyPath)path;
            Path parentPath = persistentPropertyPath.getParentPath();
            if (parentPath instanceof PersistentAssociationPath && PersistentEntityUtils.isAccessibleWithoutJoin((parent = (PersistentAssociationPath)parentPath).getAssociation(), persistentPropertyPath.getProperty())) {
                Path parentParentPath = parent.getParentPath();
                if (parentParentPath instanceof PersistentEntityRoot) {
                    return;
                }
                if (parentParentPath != null) {
                    this.joinAssociation(parentParentPath);
                }
                return;
            }
            this.joinAssociation(parentPath);
        }
    }

    private void join(PersistentAssociationPath<?, ?> associationPath) {
        String alias;
        Joined joined = this.joins.computeIfAbsent(associationPath.getPathAsString(), s -> new Joined(associationPath, associationPath.getAssociationJoinType(), associationPath.getAlias()));
        if (joined.association == associationPath) {
            return;
        }
        Join.Type type = associationPath.getAssociationJoinType();
        if (type != Join.Type.DEFAULT) {
            joined.type = type;
        }
        if ((alias = associationPath.getAlias()) != null) {
            joined.alias = alias;
        }
    }

    @Override
    public void visit(PersistentEntityRoot<?> entityRoot) {
        Set joins = entityRoot.getJoins();
        this.visitJoins(joins);
    }

    @Override
    public void visit(PersistentEntitySubquery<?> subquery) {
    }

    private void visitJoins(Set<? extends Join<?, ?>> joins) {
        for (Join<?, ?> join : joins) {
            PersistentAssociationPath persistentAssociationPath;
            if (!(join instanceof PersistentAssociationPath) || (persistentAssociationPath = (PersistentAssociationPath)join).getAssociationJoinType() == null) continue;
            this.joinIfNeeded(persistentAssociationPath, false);
            this.visitJoins(join.getJoins());
        }
    }

    private void visitPredicateExpression(Expression<?> expression) {
        if (expression instanceof IPredicate) {
            IPredicate predicateVisitable = (IPredicate)expression;
            predicateVisitable.visitPredicate(this);
        } else if (expression instanceof PersistentPropertyPath) {
            PersistentPropertyPath persistentPropertyPath = (PersistentPropertyPath)expression;
            this.joinIfNeeded(persistentPropertyPath, true);
        }
    }

    private void visitExpression(Expression<?> expression) {
        if (expression instanceof PersistentPropertyPath) {
            PersistentPropertyPath persistentPropertyPath = (PersistentPropertyPath)expression;
            this.joinIfNeeded(persistentPropertyPath, false);
        }
    }

    @Override
    public void visit(PersistentPropertyPath<?> persistentPropertyPath) {
        this.joinIfNeeded(persistentPropertyPath, false);
    }

    @Override
    public void visit(Predicate predicate) {
    }

    @Override
    public void visit(AliasedSelection<?> aliasedSelection) {
        aliasedSelection.getSelection().visitSelection(this);
    }

    @Override
    public void visit(CompoundSelection<?> compoundSelection) {
        for (Selection<?> selection : compoundSelection.getCompoundSelectionItems()) {
            if (selection instanceof ISelection) {
                ISelection selectionVisitable = (ISelection)selection;
                selectionVisitable.visitSelection(this);
                continue;
            }
            throw new IllegalStateException("Unknown selection object: " + String.valueOf(selection));
        }
    }

    @Override
    public void visit(LiteralExpression<?> literalExpression) {
    }

    @Override
    public void visit(IdExpression<?, ?> idExpression) {
    }

    @Override
    public void visit(UnaryExpression<?> unaryExpression) {
        this.visitExpression(unaryExpression.getExpression());
    }

    @Override
    public void visit(BinaryExpression<?> binaryExpression) {
        this.visitExpression(binaryExpression.getLeft());
        this.visitExpression(binaryExpression.getRight());
    }

    @Override
    public void visit(FunctionExpression<?> functionExpression) {
        functionExpression.getExpressions().forEach(this::visitExpression);
    }

    @Override
    public void visit(ConjunctionPredicate conjunction) {
        for (IExpression<Boolean> iExpression : conjunction.getPredicates()) {
            this.visitPredicateExpression(iExpression);
        }
    }

    @Override
    public void visit(DisjunctionPredicate disjunction) {
        for (IExpression<Boolean> iExpression : disjunction.getPredicates()) {
            this.visitPredicateExpression(iExpression);
        }
    }

    @Override
    public void visit(NegatedPredicate negate) {
        this.visitPredicateExpression(negate.getNegated());
    }

    @Override
    public void visit(UnaryPredicate propertyOp) {
        this.visitPredicateExpression(propertyOp.getExpression());
    }

    @Override
    public void visit(BetweenPredicate propertyBetweenPredicate) {
        this.visitPredicateExpression(propertyBetweenPredicate.getValue());
        this.visitPredicateExpression(propertyBetweenPredicate.getFrom());
        this.visitPredicateExpression(propertyBetweenPredicate.getTo());
    }

    @Override
    public void visit(BinaryPredicate binaryPredicate) {
        this.visitPredicateExpression(binaryPredicate.getLeftExpression());
        this.visitPredicateExpression(binaryPredicate.getRightExpression());
    }

    @Override
    public void visit(InPredicate<?> inPredicate) {
        this.visitPredicateExpression(inPredicate.getExpression());
        inPredicate.getValues().forEach(this::visitPredicateExpression);
    }

    @Override
    public void visit(LikePredicate likePredicate) {
        this.visitPredicateExpression(likePredicate.getExpression());
    }

    @Override
    public void visit(ExistsSubqueryPredicate existsSubqueryPredicate) {
    }

    @Internal
    public static final class Joined {
        private final PersistentAssociationPath<?, ?> association;
        private Join.Type type;
        private String alias;

        public Joined(PersistentAssociationPath<?, ?> association, Join.Type type, String alias) {
            this.association = association;
            this.type = type;
            this.alias = alias;
        }

        public PersistentAssociationPath<?, ?> getAssociation() {
            return this.association;
        }

        public Join.Type getType() {
            return this.type;
        }

        public void setType(Join.Type type) {
            this.type = type;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }
    }
}

