/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl.expression;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.jpa.criteria.ExpressionType;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.impl.ExpressionVisitor;
import io.micronaut.data.model.jpa.criteria.impl.expression.AbstractExpression;

@Internal
public final class IdExpression<E, T>
extends AbstractExpression<T> {
    private final PersistentEntityRoot<E> root;

    public IdExpression(PersistentEntityRoot<E> root) {
        super(IdExpression.getExpressionType(root));
        this.root = root;
    }

    private static <T> ExpressionType<T> getExpressionType(PersistentEntityRoot<?> root) {
        PersistentEntity persistentEntity = root.getPersistentEntity();
        if (persistentEntity.hasCompositeIdentity()) {
            return ExpressionType.OBJECT;
        }
        return root.get(persistentEntity.getIdentity().getName()).getExpressionType();
    }

    @Override
    public Class<? extends T> getJavaType() {
        PersistentEntity persistentEntity = this.root.getPersistentEntity();
        if (persistentEntity.hasCompositeIdentity()) {
            throw new IllegalStateException("IdClass is unknown!");
        }
        return this.root.get(persistentEntity.getIdentity().getName()).getJavaType();
    }

    public PersistentEntityRoot<E> getRoot() {
        return this.root;
    }

    @Override
    public void visitExpression(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String toString() {
        return "IdExpression{root=" + String.valueOf(this.root) + "}";
    }
}

