/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.model.jpa.criteria.IExpression;
import io.micronaut.data.model.jpa.criteria.impl.SelectionVisitable;
import io.micronaut.data.model.jpa.criteria.impl.SelectionVisitor;

@Internal
public final class LiteralExpression<T>
implements IExpression<T>,
SelectionVisitable {
    private final Class<T> clazz;
    @Nullable
    private final T value;

    public LiteralExpression(Class<T> clazz) {
        this.clazz = clazz;
        this.value = null;
    }

    public LiteralExpression(@Nullable T object) {
        this.clazz = object == null ? null : object.getClass();
        this.value = object;
    }

    @Override
    public void accept(SelectionVisitor selectionVisitor) {
        selectionVisitor.visit(this);
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public boolean isBoolean() {
        return this.value instanceof Boolean;
    }

    @Override
    public boolean isNumeric() {
        return this.value instanceof Number;
    }

    @Override
    public boolean isComparable() {
        return this.value instanceof Comparable;
    }

    @Nullable
    public Class<? extends T> getJavaType() {
        return this.clazz;
    }

    public String toString() {
        return "LiteralExpression{value=" + this.value + '}';
    }
}

