/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.jpa.criteria.IExpression;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import io.micronaut.data.model.jpa.criteria.impl.PredicateVisitable;
import io.micronaut.data.model.jpa.criteria.impl.QueryResultPersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.impl.SelectionVisitable;
import io.micronaut.data.model.jpa.criteria.impl.predicate.ConjunctionPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.DisjunctionPredicate;
import io.micronaut.data.model.jpa.criteria.impl.predicate.PersistentPropertyBinaryPredicate;
import io.micronaut.data.model.jpa.criteria.impl.query.QueryModelPredicateVisitor;
import io.micronaut.data.model.jpa.criteria.impl.query.QueryModelSelectionVisitor;
import io.micronaut.data.model.jpa.criteria.impl.util.Joiner;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryResult;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.metamodel.EntityType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Internal
public abstract class AbstractPersistentEntityCriteriaQuery<T>
implements PersistentEntityCriteriaQuery<T>,
QueryResultPersistentEntityCriteriaQuery {
    protected final Class<T> resultType;
    protected Predicate predicate;
    protected Selection<?> selection;
    protected PersistentEntityRoot<?> entityRoot;
    protected List<Order> orders;
    protected int max = -1;
    protected int offset = 0;
    protected boolean forUpdate;
    protected boolean distinct;

    protected AbstractPersistentEntityCriteriaQuery(Class<T> resultType) {
        this.resultType = resultType;
    }

    @Override
    public QueryResult buildQuery(QueryBuilder queryBuilder) {
        return queryBuilder.buildQuery(this.getQueryModel());
    }

    @Override
    @NonNull
    public QueryModel getQueryModel() {
        if (this.entityRoot == null) {
            throw new IllegalStateException("The root entity must be specified!");
        }
        QueryModel qm = QueryModel.from(this.entityRoot.getPersistentEntity());
        Joiner joiner = new Joiner();
        if (this.predicate instanceof PredicateVisitable) {
            PredicateVisitable predicate = (PredicateVisitable)this.predicate;
            predicate.accept(this.createPredicateVisitor(qm));
            predicate.accept(joiner);
        }
        if (this.selection instanceof SelectionVisitable) {
            SelectionVisitable selection = (SelectionVisitable)this.selection;
            selection.accept(new QueryModelSelectionVisitor(qm, this.distinct));
            selection.accept(joiner);
            SelectionVisitable entityRoot = (SelectionVisitable)((Object)this.entityRoot);
            entityRoot.accept(joiner);
        } else {
            SelectionVisitable entityRoot = (SelectionVisitable)((Object)this.entityRoot);
            entityRoot.accept(new QueryModelSelectionVisitor(qm, this.distinct));
            entityRoot.accept(joiner);
        }
        if (this.orders != null && !this.orders.isEmpty()) {
            List<Sort.Order> sortOrders = this.orders.stream().map(o -> {
                PersistentPropertyPath propertyPath = CriteriaUtils.requireProperty(o.getExpression());
                joiner.joinIfNeeded(propertyPath);
                String name = propertyPath.getProperty().getName();
                if (o.isAscending()) {
                    return Sort.Order.asc(name);
                }
                return Sort.Order.desc(name);
            }).collect(Collectors.toList());
            qm.sort(Sort.of(sortOrders));
        }
        for (Map.Entry<String, Joiner.Joined> e : joiner.getJoins().entrySet()) {
            qm.join(e.getKey(), Optional.ofNullable(e.getValue().getType()).orElse(Join.Type.DEFAULT), e.getValue().getAlias());
        }
        qm.max(this.max);
        qm.offset(this.offset);
        if (this.forUpdate) {
            qm.forUpdate();
        }
        return qm;
    }

    @NonNull
    protected QueryModelPredicateVisitor createPredicateVisitor(QueryModel queryModel) {
        return new QueryModelPredicateVisitor(queryModel);
    }

    @Override
    public PersistentEntityCriteriaQuery<T> max(int max) {
        this.max = max;
        return this;
    }

    @Override
    public PersistentEntityCriteriaQuery<T> offset(int offset) {
        this.offset = offset;
        return this;
    }

    @Override
    public PersistentEntityCriteriaQuery<T> forUpdate(boolean forUpdate) {
        this.forUpdate = forUpdate;
        return this;
    }

    @Override
    public PersistentEntityCriteriaQuery<T> select(Selection<? extends T> selection) {
        this.selection = Objects.requireNonNull(selection);
        return this;
    }

    @Override
    public PersistentEntityCriteriaQuery<T> multiselect(Selection<?> ... selections) {
        Objects.requireNonNull(selections);
        this.selection = selections.length > 0 ? (selections.length == 1 ? selections[0] : new Selection(Arrays.asList(selections))) : null;
        return this;
    }

    @Override
    public PersistentEntityCriteriaQuery<T> multiselect(List<Selection<?>> selectionList) {
        Objects.requireNonNull(selectionList);
        this.selection = !selectionList.isEmpty() ? (selectionList.size() == 1 ? selectionList.iterator().next() : new Selection(selectionList)) : null;
        return this;
    }

    @Override
    public abstract <X> PersistentEntityRoot<X> from(Class<X> var1);

    @Override
    public abstract <X> PersistentEntityRoot<X> from(PersistentEntity var1);

    @Override
    public <X> PersistentEntityRoot<X> from(EntityType<X> entity) {
        if (this.entityRoot != null) {
            throw new IllegalStateException("The root entity is already specified!");
        }
        return null;
    }

    @Override
    public PersistentEntityCriteriaQuery<T> where(Expression<Boolean> restriction) {
        this.predicate = new ConjunctionPredicate(Collections.singleton((IExpression)restriction));
        return this;
    }

    @Override
    public PersistentEntityCriteriaQuery<T> where(Predicate ... restrictions) {
        Objects.requireNonNull(restrictions);
        this.predicate = restrictions.length > 0 ? (restrictions.length == 1 ? restrictions[0] : new ConjunctionPredicate(((Stream)Arrays.stream(restrictions).sequential()).map(x -> (IExpression)x).collect(Collectors.toList()))) : null;
        return this;
    }

    @Override
    public PersistentEntityCriteriaQuery<T> groupBy(Expression<?> ... grouping) {
        throw CriteriaUtils.notSupportedOperation();
    }

    @Override
    public PersistentEntityCriteriaQuery<T> groupBy(List<Expression<?>> grouping) {
        throw CriteriaUtils.notSupportedOperation();
    }

    @Override
    public PersistentEntityCriteriaQuery<T> having(Expression<Boolean> restriction) {
        throw CriteriaUtils.notSupportedOperation();
    }

    @Override
    public PersistentEntityCriteriaQuery<T> having(Predicate ... restrictions) {
        throw CriteriaUtils.notSupportedOperation();
    }

    @Override
    public PersistentEntityCriteriaQuery<T> orderBy(Order ... o) {
        this.orders = Arrays.asList(Objects.requireNonNull(o));
        return this;
    }

    @Override
    public PersistentEntityCriteriaQuery<T> orderBy(List<Order> o) {
        this.orders = Objects.requireNonNull(o);
        return this;
    }

    @Override
    public PersistentEntityCriteriaQuery<T> distinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public Set<Root<?>> getRoots() {
        if (this.entityRoot != null) {
            return Collections.singleton(this.entityRoot);
        }
        return Collections.emptySet();
    }

    public List<Expression<?>> getGroupList() {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Predicate getGroupRestriction() {
        throw CriteriaUtils.notSupportedOperation();
    }

    public boolean isDistinct() {
        return false;
    }

    public Class<T> getResultType() {
        return this.resultType;
    }

    public List<Order> getOrderList() {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Set<ParameterExpression<?>> getParameters() {
        throw CriteriaUtils.notSupportedOperation();
    }

    public <U> Subquery<U> subquery(Class<U> type) {
        throw CriteriaUtils.notSupportedOperation();
    }

    public Selection<T> getSelection() {
        return this.selection;
    }

    public Predicate getRestriction() {
        return this.predicate;
    }

    public final boolean hasOnlyIdRestriction() {
        return this.isOnlyIdRestriction((Expression<?>)this.predicate);
    }

    private boolean isOnlyIdRestriction(Expression<?> predicate) {
        DisjunctionPredicate disjunctionPredicate;
        ConjunctionPredicate conjunctionPredicate;
        if (predicate instanceof PersistentPropertyBinaryPredicate) {
            PersistentPropertyBinaryPredicate pp = (PersistentPropertyBinaryPredicate)predicate;
            return pp.getProperty() == pp.getProperty().getOwner().getIdentity();
        }
        if (predicate instanceof ConjunctionPredicate && (conjunctionPredicate = (ConjunctionPredicate)predicate).getPredicates().size() == 1) {
            return this.isOnlyIdRestriction((Expression)conjunctionPredicate.getPredicates().iterator().next());
        }
        if (predicate instanceof DisjunctionPredicate && (disjunctionPredicate = (DisjunctionPredicate)predicate).getPredicates().size() == 1) {
            return this.isOnlyIdRestriction((Expression)disjunctionPredicate.getPredicates().iterator().next());
        }
        return false;
    }

    public final boolean hasVersionRestriction() {
        if (this.entityRoot.getPersistentEntity().getVersion() == null) {
            return false;
        }
        return CriteriaUtils.hasVersionPredicate(this.predicate);
    }
}

