/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.operations;

import io.micronaut.context.ApplicationContextProvider;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.model.runtime.UpdateBatchOperation;
import io.micronaut.data.model.runtime.UpdateOperation;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface RepositoryOperations
extends ApplicationContextProvider {
    @NonNull
    default public <T> RuntimePersistentEntity<T> getEntity(@NonNull Class<T> type) {
        return PersistentEntity.of(type);
    }

    @Nullable
    public <T> T findOne(@NonNull Class<T> var1, @NonNull Serializable var2);

    @Nullable
    public <T, R> R findOne(@NonNull PreparedQuery<T, R> var1);

    public <T> boolean exists(@NonNull PreparedQuery<T, Boolean> var1);

    @NonNull
    public <T> Iterable<T> findAll(@NonNull PagedQuery<T> var1);

    public <T> long count(PagedQuery<T> var1);

    @NonNull
    public <T, R> Iterable<R> findAll(@NonNull PreparedQuery<T, R> var1);

    @NonNull
    public <T, R> Stream<R> findStream(@NonNull PreparedQuery<T, R> var1);

    @NonNull
    public <T> Stream<T> findStream(@NonNull PagedQuery<T> var1);

    public <R> Page<R> findPage(@NonNull PagedQuery<R> var1);

    @NonNull
    public <T> T persist(@NonNull InsertOperation<T> var1);

    @NonNull
    public <T> T update(@NonNull UpdateOperation<T> var1);

    @NonNull
    default public <T> Iterable<T> updateAll(@NonNull UpdateBatchOperation<T> operation) {
        return operation.split().stream().map(this::update).collect(Collectors.toList());
    }

    @NonNull
    default public <T> Iterable<T> persistAll(@NonNull InsertBatchOperation<T> operation) {
        return operation.split().stream().map(this::persist).collect(Collectors.toList());
    }

    @NonNull
    public Optional<Number> executeUpdate(@NonNull PreparedQuery<?, Number> var1);

    @NonNull
    default public Optional<Number> executeDelete(@NonNull PreparedQuery<?, Number> preparedQuery) {
        return this.executeUpdate(preparedQuery);
    }

    public <T> int delete(@NonNull DeleteOperation<T> var1);

    public <T> Optional<Number> deleteAll(@NonNull DeleteBatchOperation<T> var1);

    @NonNull
    default public Map<String, Object> getQueryHints(@NonNull StoredQuery<?, ?> storedQuery) {
        return Collections.emptyMap();
    }
}

