/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.builder;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.data.model.DataType;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public interface QueryResult {
    @NonNull
    public String getQuery();

    @NonNull
    public Map<String, String> getParameters();

    @NonNull
    public Map<String, DataType> getParameterTypes();

    default public Set<String> getAdditionalRequiredParameters() {
        return Collections.emptySet();
    }

    @NonNull
    public static QueryResult of(final @NonNull String query, final @Nullable Map<String, String> parameters, final @Nullable Map<String, DataType> parameterTypes, final @Nullable Set<String> additionalRequiredParameters) {
        ArgumentUtils.requireNonNull((String)"query", (Object)query);
        return new QueryResult(){

            @Override
            @NonNull
            public String getQuery() {
                return query;
            }

            @Override
            @NonNull
            public Map<String, String> getParameters() {
                return parameters != null ? Collections.unmodifiableMap(parameters) : Collections.emptyMap();
            }

            @Override
            @NonNull
            public Map<String, DataType> getParameterTypes() {
                return parameterTypes != null ? Collections.unmodifiableMap(parameterTypes) : Collections.emptyMap();
            }

            @Override
            public Set<String> getAdditionalRequiredParameters() {
                return additionalRequiredParameters != null ? additionalRequiredParameters : Collections.emptySet();
            }
        };
    }
}

