/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.document.serde.defaults;

import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.data.annotation.MappedProperty;
import io.micronaut.data.document.serde.CustomConverterDeserializer;
import io.micronaut.data.model.runtime.AttributeConverterRegistry;
import io.micronaut.data.model.runtime.convert.AttributeConverter;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.util.CustomizableDeserializer;
import jakarta.inject.Singleton;
import org.jspecify.annotations.NonNull;

@Singleton
final class DefaultCustomConverterDeserializer
implements CustomConverterDeserializer,
CustomizableDeserializer<Object> {
    private final AttributeConverterRegistry attributeConverterRegistry;

    public DefaultCustomConverterDeserializer(AttributeConverterRegistry attributeConverterRegistry) {
        this.attributeConverterRegistry = attributeConverterRegistry;
    }

    public @NonNull Deserializer<Object> createSpecific(Deserializer.DecoderContext decoderContext, Argument<? super Object> type) throws SerdeException {
        Class converterClass = (Class)type.getAnnotationMetadata().classValue(MappedProperty.class, "converter").orElseThrow(IllegalStateException::new);
        Class converterPersistedType = (Class)type.getAnnotationMetadata().classValue(MappedProperty.class, "converterPersistedType").orElseThrow(IllegalStateException::new);
        Argument convertedType = Argument.of((Class)converterPersistedType);
        AttributeConverter converter = this.attributeConverterRegistry.getConverter(converterClass);
        Deserializer deserializer = decoderContext.findDeserializer(convertedType);
        return (decoder, decoderContext1, type1) -> {
            if (decoder.decodeNull()) {
                return null;
            }
            Object deserialized = deserializer.deserialize(decoder, decoderContext1, convertedType);
            return converter.convertToEntityValue(deserialized, (ConversionContext)ConversionContext.of((Argument)convertedType));
        };
    }
}

