/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.document.model.query.builder;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.repeatable.WhereSpecifications;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.naming.NamingStrategies;
import io.micronaut.data.model.naming.NamingStrategy;
import io.micronaut.data.model.query.BindingParameter;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.builder.AbstractSqlLikeQueryBuilder;
import io.micronaut.data.model.query.builder.QueryParameterBinding;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.BiConsumer;

public final class CosmosSqlQueryBuilder
extends SqlQueryBuilder {
    private static final String VALUE = "VALUE ";
    private static final String SELECT_COUNT = "COUNT(1)";
    private static final String JOIN = " JOIN ";
    private static final String IN = " IN ";
    private static final String IS_NULL = "IS_NULL";
    private static final String IS_DEFINED = "IS_DEFINED";
    private static final String ARRAY_CONTAINS = "ARRAY_CONTAINS";
    private static final NamingStrategy RAW_NAMING_STRATEGY = new NamingStrategies.Raw();

    @Creator
    public CosmosSqlQueryBuilder(AnnotationMetadata annotationMetadata) {
        super(annotationMetadata);
        this.initializeCriteriaHandlers();
    }

    public CosmosSqlQueryBuilder() {
        this.initializeCriteriaHandlers();
    }

    protected String asLiteral(Object value) {
        if (value instanceof Boolean) {
            return value.toString();
        }
        return super.asLiteral(value);
    }

    protected void appendProjectionRowCount(StringBuilder queryString, String logicalName) {
        queryString.append(SELECT_COUNT);
    }

    protected NamingStrategy getNamingStrategy(PersistentEntity entity) {
        return entity.findNamingStrategy().orElse(RAW_NAMING_STRATEGY);
    }

    protected NamingStrategy getNamingStrategy(PersistentPropertyPath propertyPath) {
        return propertyPath.findNamingStrategy().orElse(RAW_NAMING_STRATEGY);
    }

    protected void traversePersistentProperties(List<Association> associations, PersistentProperty property, BiConsumer<List<Association>, PersistentProperty> consumerProperty) {
        if (property instanceof Embedded) {
            consumerProperty.accept(associations, property);
            return;
        }
        super.traversePersistentProperties(associations, property, consumerProperty);
    }

    public QueryResult buildQuery(@NonNull AnnotationMetadata annotationMetadata, @NonNull QueryModel query) {
        ArgumentUtils.requireNonNull((String)"annotationMetadata", (Object)annotationMetadata);
        ArgumentUtils.requireNonNull((String)"query", (Object)query);
        AbstractSqlLikeQueryBuilder.QueryState queryState = new AbstractSqlLikeQueryBuilder.QueryState((AbstractSqlLikeQueryBuilder)this, query, true, true);
        ArrayList joinPaths = new ArrayList(query.getJoinPaths());
        joinPaths.sort((o1, o2) -> Comparator.comparingInt(String::length).thenComparing(String::compareTo).compare(o1.getPath(), o2.getPath()));
        for (JoinPath joinPath : joinPaths) {
            queryState.applyJoin(joinPath);
        }
        StringBuilder select = new StringBuilder("SELECT ");
        String logicalName = queryState.getRootAlias();
        PersistentEntity entity = queryState.getEntity();
        List projections = query.getProjections();
        this.buildSelect(annotationMetadata, queryState, select, projections, logicalName, entity);
        if (projections.size() == 1 && !(projections.get(0) instanceof QueryModel.LiteralProjection) && !(projections.get(0) instanceof QueryModel.RootEntityProjection) && select.indexOf(",") == -1) {
            select.insert("SELECT ".length(), VALUE);
        }
        select.append(" FROM ").append(this.getTableName(entity)).append(' ').append(logicalName);
        QueryModel queryModel = queryState.getQueryModel();
        Collection allPaths = queryModel.getJoinPaths();
        this.appendJoins(queryState, select, allPaths, null);
        queryState.getQuery().insert(0, select);
        QueryModel.Junction criteria = query.getCriteria();
        if (!criteria.isEmpty() || annotationMetadata.hasStereotype(WhereSpecifications.class) || queryState.getEntity().getAnnotationMetadata().hasStereotype(WhereSpecifications.class)) {
            this.buildWhereClause(annotationMetadata, criteria, queryState);
        }
        this.appendOrder(annotationMetadata, query, queryState);
        this.appendForUpdate(AbstractSqlLikeQueryBuilder.QueryPosition.END_OF_QUERY, query, queryState.getQuery());
        return QueryResult.of((String)queryState.getFinalQuery(), (List)queryState.getQueryParts(), (List)queryState.getParameterBindings(), (Map)queryState.getAdditionalRequiredParameters(), (int)query.getMax(), (long)query.getOffset(), (Collection)queryState.getJoinPaths());
    }

    @Internal
    protected void selectAllColumnsFromJoinPaths(AbstractSqlLikeQueryBuilder.QueryState queryState, StringBuilder queryBuffer, Collection<JoinPath> allPaths, @Nullable Map<JoinPath, String> joinAliasOverride) {
    }

    private void appendJoins(AbstractSqlLikeQueryBuilder.QueryState queryState, StringBuilder queryBuffer, Collection<JoinPath> allPaths, @Nullable Map<JoinPath, String> joinAliasOverride) {
        if (CollectionUtils.isEmpty(allPaths)) {
            return;
        }
        String logicalName = queryState.getRootAlias();
        HashMap<CallSite, String> joinedPaths = new HashMap<CallSite, String>();
        for (JoinPath joinPath : allPaths) {
            Association association = joinPath.getAssociation();
            if (association instanceof Embedded) continue;
            String joinAlias = joinAliasOverride == null ? this.getAliasName(joinPath) : joinAliasOverride.get(joinPath);
            String path = logicalName + "." + joinPath.getPath();
            for (Map.Entry entry : joinedPaths.entrySet()) {
                String joinedPath = (String)entry.getKey();
                String prefix = joinedPath + ".";
                if (!path.startsWith(prefix) || joinedPath.equals(path)) continue;
                path = (String)entry.getValue() + "." + path.replace(prefix, "");
                break;
            }
            queryBuffer.append(JOIN).append(joinAlias).append(IN).append(path);
            joinedPaths.put((CallSite)((Object)path), joinAlias);
        }
    }

    protected boolean appendAssociationProjection(AbstractSqlLikeQueryBuilder.QueryState queryState, StringBuilder queryString, PersistentProperty property, PersistentPropertyPath propertyPath, String columnAlias) {
        String joinedPath = propertyPath.getPath();
        if (!queryState.isJoined(joinedPath)) {
            queryString.setLength(queryString.length() - 1);
            return false;
        }
        String joinAlias = queryState.computeAlias(propertyPath.getPath());
        this.selectAllColumns(((Association)property).getAssociatedEntity(), joinAlias, queryString);
        return true;
    }

    protected void selectAllColumns(AnnotationMetadata annotationMetadata, AbstractSqlLikeQueryBuilder.QueryState queryState, StringBuilder queryBuffer) {
        queryBuffer.append("DISTINCT").append(' ').append(VALUE).append(queryState.getRootAlias());
    }

    protected void buildJoin(String joinType, StringBuilder sb, AbstractSqlLikeQueryBuilder.QueryState queryState, List<Association> joinAssociationsPath, String joinAlias, Association association, PersistentEntity associatedEntity, PersistentEntity associationOwner, String currentJoinAlias) {
    }

    protected StringBuilder appendDeleteClause(StringBuilder queryString) {
        return queryString.append("SELECT * ").append(" FROM ");
    }

    protected boolean isAliasForBatch(PersistentEntity persistentEntity, AnnotationMetadata annotationMetadata) {
        return true;
    }

    protected boolean computePropertyPaths() {
        return false;
    }

    public QueryResult buildInsert(AnnotationMetadata repositoryMetadata, PersistentEntity entity) {
        return null;
    }

    public QueryResult buildUpdate(AnnotationMetadata annotationMetadata, QueryModel query, Map<String, Object> propertiesToUpdate) {
        final QueryResult queryResult = super.buildUpdate(annotationMetadata, query, propertiesToUpdate);
        String resultQuery = queryResult.getQuery();
        PersistentEntity entity = query.getPersistentEntity();
        String tableAlias = this.getAliasName(entity);
        String tableName = this.getTableName(entity);
        final String finalQuery = "SELECT * FROM " + tableName + " " + tableAlias + " " + resultQuery.substring(resultQuery.toLowerCase(Locale.ROOT).indexOf("where"));
        StringJoiner stringJoiner = new StringJoiner(",");
        propertiesToUpdate.keySet().forEach(stringJoiner::add);
        final String update = stringJoiner.toString();
        return new QueryResult(){

            @NonNull
            public String getQuery() {
                return finalQuery;
            }

            public String getUpdate() {
                return update;
            }

            public List<String> getQueryParts() {
                return queryResult.getQueryParts();
            }

            public List<QueryParameterBinding> getParameterBindings() {
                return queryResult.getParameterBindings();
            }

            public Map<String, String> getAdditionalRequiredParameters() {
                return queryResult.getAdditionalRequiredParameters();
            }
        };
    }

    @NonNull
    public QueryResult buildPagination(@NonNull Pageable pageable) {
        int size = pageable.getSize();
        if (size > 0) {
            StringBuilder builder = new StringBuilder(" ");
            long from = pageable.getOffset();
            builder.append("OFFSET ").append(from).append(" LIMIT ").append(size).append(" ");
            return QueryResult.of((String)builder.toString(), Collections.emptyList(), Collections.emptyList(), Collections.emptyMap());
        }
        return QueryResult.of((String)"", Collections.emptyList(), Collections.emptyList(), Collections.emptyMap());
    }

    private void initializeCriteriaHandlers() {
        this.addCriterionHandler(QueryModel.IsNull.class, (ctx, criterion) -> {
            ctx.query().append("NOT").append(' ').append(IS_DEFINED).append('(');
            this.appendPropertyRef(ctx.query(), ctx.getAnnotationMetadata(), ctx.getPersistentEntity(), ctx.getRequiredProperty((QueryModel.PropertyNameCriterion)criterion));
            ctx.query().append(')').append(' ').append("OR").append(' ');
            ctx.query().append(IS_NULL).append('(');
            this.appendPropertyRef(ctx.query(), ctx.getAnnotationMetadata(), ctx.getPersistentEntity(), ctx.getRequiredProperty((QueryModel.PropertyNameCriterion)criterion));
            ctx.query().append(')');
        });
        this.addCriterionHandler(QueryModel.IsNotNull.class, (ctx, criterion) -> {
            ctx.query().append(IS_DEFINED).append('(');
            this.appendPropertyRef(ctx.query(), ctx.getAnnotationMetadata(), ctx.getPersistentEntity(), ctx.getRequiredProperty((QueryModel.PropertyNameCriterion)criterion));
            ctx.query().append(')').append(' ').append("AND").append(' ');
            ctx.query().append("NOT").append(' ').append(IS_NULL).append('(');
            this.appendPropertyRef(ctx.query(), ctx.getAnnotationMetadata(), ctx.getPersistentEntity(), ctx.getRequiredProperty((QueryModel.PropertyNameCriterion)criterion));
            ctx.query().append(')');
        });
        this.addCriterionHandler(QueryModel.IsEmpty.class, (ctx, criterion) -> {
            ctx.query().append("NOT").append(' ').append(IS_DEFINED).append('(');
            this.appendPropertyRef(ctx.query(), ctx.getAnnotationMetadata(), ctx.getPersistentEntity(), ctx.getRequiredProperty((QueryModel.PropertyNameCriterion)criterion));
            ctx.query().append(')').append(' ').append("OR").append(' ');
            ctx.query().append(IS_NULL).append('(');
            this.appendPropertyRef(ctx.query(), ctx.getAnnotationMetadata(), ctx.getPersistentEntity(), ctx.getRequiredProperty((QueryModel.PropertyNameCriterion)criterion));
            ctx.query().append(')').append(' ').append("OR").append(' ');
            this.appendPropertyRef(ctx.query(), ctx.getAnnotationMetadata(), ctx.getPersistentEntity(), ctx.getRequiredProperty((QueryModel.PropertyNameCriterion)criterion));
            ctx.query().append(" = ").append("''");
        });
        this.addCriterionHandler(QueryModel.IsNotEmpty.class, (ctx, criterion) -> {
            ctx.query().append(IS_DEFINED).append('(');
            this.appendPropertyRef(ctx.query(), ctx.getAnnotationMetadata(), ctx.getPersistentEntity(), ctx.getRequiredProperty((QueryModel.PropertyNameCriterion)criterion));
            ctx.query().append(')').append(' ').append("AND").append(' ');
            ctx.query().append("NOT").append(' ').append(IS_NULL).append('(');
            this.appendPropertyRef(ctx.query(), ctx.getAnnotationMetadata(), ctx.getPersistentEntity(), ctx.getRequiredProperty((QueryModel.PropertyNameCriterion)criterion));
            ctx.query().append(')').append(' ').append("AND").append(' ');
            this.appendPropertyRef(ctx.query(), ctx.getAnnotationMetadata(), ctx.getPersistentEntity(), ctx.getRequiredProperty((QueryModel.PropertyNameCriterion)criterion));
            ctx.query().append(" != ").append("''");
        });
        this.addCriterionHandler(QueryModel.ArrayContains.class, (ctx, criterion) -> {
            AbstractSqlLikeQueryBuilder.QueryPropertyPath propertyPath = ctx.getRequiredProperty(criterion.getProperty(), QueryModel.ArrayContains.class);
            StringBuilder whereClause = ctx.query();
            whereClause.append(ARRAY_CONTAINS).append('(');
            this.appendPropertyRef(whereClause, ctx.getAnnotationMetadata(), ctx.getPersistentEntity(), propertyPath);
            whereClause.append(',');
            Object value = criterion.getValue();
            if (value instanceof BindingParameter) {
                ctx.pushParameter((BindingParameter)value, this.newBindingContext(propertyPath.getPropertyPath()));
            } else {
                this.asLiterals(ctx.query(), value);
            }
            whereClause.append(',').append("true").append(')');
        });
    }
}

