/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.document.model.query.builder;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.exceptions.MappingException;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentEntityUtils;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.naming.NamingStrategy;
import io.micronaut.data.model.query.BindingParameter;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryParameterBinding;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.serde.config.annotation.SerdeConfig;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Internal
public final class MongoQueryBuilder
implements QueryBuilder {
    public static final String QUERY_PARAMETER_PLACEHOLDER = "$mn_qp";
    public static final String MONGO_DATE_IDENTIFIER = "$date";
    public static final String MONGO_ID_FIELD = "_id";
    private static final String REGEX = "$regex";
    private static final String NOT = "$not";
    private static final String OPTIONS = "$options";
    private final Map<Class, CriterionHandler> queryHandlers = new HashMap<Class, CriterionHandler>(30);

    public MongoQueryBuilder() {
        this.addCriterionHandler(QueryModel.Negation.class, (ctx, obj, negation) -> {
            if (negation.getCriteria().size() != 1) throw new IllegalStateException("Negation not supported on multiple criterion: " + negation);
            QueryModel.Criterion criterion = (QueryModel.Criterion)negation.getCriteria().iterator().next();
            if (criterion instanceof QueryModel.In) {
                QueryModel.In in = (QueryModel.In)criterion;
                this.handleCriterion(ctx, obj, (QueryModel.Criterion)new QueryModel.NotIn(in.getName(), in.getValue()));
                return;
            }
            if (criterion instanceof QueryModel.NotIn) {
                QueryModel.NotIn notIn = (QueryModel.NotIn)criterion;
                this.handleCriterion(ctx, obj, (QueryModel.Criterion)new QueryModel.In(notIn.getName(), notIn.getValue()));
                return;
            }
            if (!(criterion instanceof QueryModel.PropertyCriterion) && !(criterion instanceof QueryModel.PropertyComparisonCriterion)) throw new IllegalStateException("Negation is not supported for this criterion: " + criterion);
            LinkedHashMap<String, Object> neg = new LinkedHashMap<String, Object>();
            this.handleCriterion(ctx, neg, criterion);
            if (neg.size() != 1) {
                throw new IllegalStateException("Expected size of 1");
            }
            String key = (String)neg.keySet().iterator().next();
            obj.put(key, Collections.singletonMap(NOT, neg.get(key)));
        });
        this.addCriterionHandler(QueryModel.Conjunction.class, (ctx, sb, conjunction) -> this.handleJunction(ctx, sb, (QueryModel.Junction)conjunction, "$and"));
        this.addCriterionHandler(QueryModel.Disjunction.class, (ctx, sb, disjunction) -> this.handleJunction(ctx, sb, (QueryModel.Junction)disjunction, "$or"));
        this.addCriterionHandler(QueryModel.IsTrue.class, (context, sb, criterion) -> this.handleCriterion(context, sb, (QueryModel.Criterion)new QueryModel.Equals(criterion.getProperty(), (Object)true)));
        this.addCriterionHandler(QueryModel.IsFalse.class, (context, sb, criterion) -> this.handleCriterion(context, sb, (QueryModel.Criterion)new QueryModel.Equals(criterion.getProperty(), (Object)false)));
        this.addCriterionHandler(QueryModel.IdEquals.class, (context, sb, criterion) -> this.handleCriterion(context, sb, (QueryModel.Criterion)new QueryModel.Equals("id", criterion.getValue())));
        this.addCriterionHandler(QueryModel.VersionEquals.class, (context, sb, criterion) -> this.handleCriterion(context, sb, (QueryModel.Criterion)new QueryModel.Equals(context.getPersistentEntity().getVersion().getName(), criterion.getValue())));
        this.addCriterionHandler(QueryModel.GreaterThan.class, this.propertyOperatorExpression("$gt"));
        this.addCriterionHandler(QueryModel.GreaterThanEquals.class, this.propertyOperatorExpression("$gte"));
        this.addCriterionHandler(QueryModel.LessThan.class, this.propertyOperatorExpression("$lt"));
        this.addCriterionHandler(QueryModel.LessThanEquals.class, this.propertyOperatorExpression("$lte"));
        this.addCriterionHandler(QueryModel.IsNull.class, (context, sb, criterion) -> this.handleCriterion(context, sb, (QueryModel.Criterion)new QueryModel.Equals(criterion.getProperty(), null)));
        this.addCriterionHandler(QueryModel.IsNotNull.class, (context, sb, criterion) -> this.handleCriterion(context, sb, (QueryModel.Criterion)new QueryModel.NotEquals(criterion.getProperty(), null)));
        this.addCriterionHandler(QueryModel.IsNotNull.class, (context, sb, criterion) -> this.handleCriterion(context, sb, (QueryModel.Criterion)new QueryModel.NotEquals(criterion.getProperty(), null)));
        this.addCriterionHandler(QueryModel.GreaterThanProperty.class, this.comparison("$gt"));
        this.addCriterionHandler(QueryModel.GreaterThanEqualsProperty.class, this.comparison("$gte"));
        this.addCriterionHandler(QueryModel.LessThanProperty.class, this.comparison("$lt"));
        this.addCriterionHandler(QueryModel.LessThanEqualsProperty.class, this.comparison("$lte"));
        this.addCriterionHandler(QueryModel.EqualsProperty.class, this.comparison("$eq"));
        this.addCriterionHandler(QueryModel.NotEqualsProperty.class, this.comparison("$ne"));
        this.addCriterionHandler(QueryModel.Between.class, (context, obj, criterion) -> {
            QueryModel.Conjunction conjunction = new QueryModel.Conjunction();
            conjunction.add((QueryModel.Criterion)new QueryModel.GreaterThanEquals(criterion.getProperty(), criterion.getFrom()));
            conjunction.add((QueryModel.Criterion)new QueryModel.LessThanEquals(criterion.getProperty(), criterion.getTo()));
            this.handleCriterion(context, obj, (QueryModel.Criterion)conjunction);
        });
        this.addCriterionHandler(QueryModel.Regex.class, this.propertyOperatorExpression(REGEX, value -> {
            if (value instanceof BindingParameter) {
                return value;
            }
            return new RegexPattern(value.toString());
        }));
        this.addCriterionHandler(QueryModel.IsEmpty.class, (context, obj, criterion) -> {
            String criterionPropertyName = this.getCriterionPropertyName(criterion.getProperty(), context);
            obj.put("$or", Arrays.asList(Collections.singletonMap(criterionPropertyName, Collections.singletonMap("$eq", "")), Collections.singletonMap(criterionPropertyName, Collections.singletonMap("$exists", false))));
        });
        this.addCriterionHandler(QueryModel.IsNotEmpty.class, (context, obj, criterion) -> {
            String criterionPropertyName = this.getCriterionPropertyName(criterion.getProperty(), context);
            obj.put("$and", Arrays.asList(Collections.singletonMap(criterionPropertyName, Collections.singletonMap("$ne", "")), Collections.singletonMap(criterionPropertyName, Collections.singletonMap("$exists", true))));
        });
        this.addCriterionHandler(QueryModel.In.class, (context, obj, criterion) -> {
            PersistentPropertyPath propertyPath = context.getRequiredProperty((QueryModel.PropertyNameCriterion)criterion);
            Object value = criterion.getValue();
            String criterionPropertyName = this.getCriterionPropertyName(criterion.getProperty(), context);
            if (value instanceof Iterable) {
                List values = CollectionUtils.iterableToList((Iterable)((Iterable)value));
                obj.put(criterionPropertyName, Collections.singletonMap("$in", values.stream().map(val -> this.valueRepresentation(context, propertyPath, val)).collect(Collectors.toList())));
            } else {
                obj.put(criterionPropertyName, Collections.singletonMap("$in", Collections.singletonList(this.valueRepresentation(context, propertyPath, value))));
            }
        });
        this.addCriterionHandler(QueryModel.NotIn.class, (context, obj, criterion) -> {
            PersistentPropertyPath propertyPath = context.getRequiredProperty((QueryModel.PropertyNameCriterion)criterion);
            Object value = criterion.getValue();
            String criterionPropertyName = this.getCriterionPropertyName(criterion.getProperty(), context);
            if (value instanceof Iterable) {
                List values = CollectionUtils.iterableToList((Iterable)((Iterable)value));
                obj.put(criterionPropertyName, Collections.singletonMap("$nin", values.stream().map(val -> this.valueRepresentation(context, propertyPath, val)).collect(Collectors.toList())));
            } else {
                obj.put(criterionPropertyName, Collections.singletonMap("$nin", Collections.singletonList(this.valueRepresentation(context, propertyPath, value))));
            }
        });
        this.addCriterionHandler(QueryModel.Equals.class, (context, obj, criterion) -> {
            if (criterion.isIgnoreCase()) {
                this.handleRegexPropertyExpression(context, obj, criterion, true, false, true, true);
                return;
            }
            this.handlePropertyOperatorExpression(context, obj, criterion, "$eq", null);
        });
        this.addCriterionHandler(QueryModel.NotEquals.class, (context, obj, criterion) -> {
            if (criterion.isIgnoreCase()) {
                this.handleRegexPropertyExpression(context, obj, criterion, true, true, true, true);
                return;
            }
            this.handlePropertyOperatorExpression(context, obj, criterion, "$ne", null);
        });
        this.addCriterionHandler(QueryModel.StartsWith.class, (context, obj, criterion) -> this.handleRegexPropertyExpression(context, obj, criterion, criterion.isIgnoreCase(), false, true, false));
        this.addCriterionHandler(QueryModel.EndsWith.class, (context, obj, criterion) -> this.handleRegexPropertyExpression(context, obj, criterion, criterion.isIgnoreCase(), false, false, true));
        this.addCriterionHandler(QueryModel.Contains.class, (context, obj, criterion) -> this.handleRegexPropertyExpression(context, obj, criterion, criterion.isIgnoreCase(), false, false, false));
        this.addCriterionHandler(QueryModel.ArrayContains.class, (context, obj, criterion) -> {
            List<Object> criteriaValue;
            PersistentPropertyPath propertyPath = context.getRequiredProperty((QueryModel.PropertyNameCriterion)criterion);
            Object value = criterion.getValue();
            String criterionPropertyName = this.getCriterionPropertyName(criterion.getProperty(), context);
            if (value instanceof Iterable) {
                List values = CollectionUtils.iterableToList((Iterable)((Iterable)value));
                criteriaValue = values.stream().map(val -> this.valueRepresentation(context, propertyPath, val)).collect(Collectors.toList());
            } else {
                criteriaValue = Collections.singletonList(this.valueRepresentation(context, propertyPath, value));
            }
            obj.put(criterionPropertyName, Collections.singletonMap("$all", criteriaValue));
        });
    }

    private <T extends QueryModel.PropertyCriterion> CriterionHandler<T> propertyOperatorExpression(String op) {
        return this.propertyOperatorExpression(op, null);
    }

    private <T extends QueryModel.PropertyCriterion> CriterionHandler<T> propertyOperatorExpression(String op, Function<Object, Object> mapper) {
        return (context, obj, criterion) -> this.handlePropertyOperatorExpression(context, obj, criterion, op, mapper);
    }

    private <T extends QueryModel.PropertyCriterion> void handlePropertyOperatorExpression(CriteriaContext context, Map<String, Object> obj, T criterion, String op, Function<Object, Object> mapper) {
        Object value = criterion.getValue();
        if (mapper != null) {
            value = mapper.apply(value);
        }
        PersistentPropertyPath propertyPath = context.getRequiredProperty((QueryModel.PropertyNameCriterion)criterion);
        Object finalValue = value;
        this.traversePersistentProperties(propertyPath.getAssociations(), propertyPath.getProperty(), (associations, property) -> {
            String path = this.asPath((List<Association>)associations, (PersistentProperty)property);
            obj.put(path, Collections.singletonMap(op, this.valueRepresentation(context, propertyPath, PersistentPropertyPath.of((List)associations, (PersistentProperty)property), finalValue)));
        });
    }

    private <T extends QueryModel.PropertyCriterion> void handleRegexPropertyExpression(CriteriaContext context, Map<String, Object> obj, T criterion, boolean ignoreCase, boolean negate, boolean startsWith, boolean endsWith) {
        Object regexValue;
        PersistentPropertyPath propertyPath = context.getRequiredProperty((QueryModel.PropertyNameCriterion)criterion);
        Object value = criterion.getValue();
        HashMap<String, String> regexCriteria = new HashMap<String, String>(2);
        regexCriteria.put(OPTIONS, ignoreCase ? "i" : "");
        if (value instanceof BindingParameter) {
            int index = context.pushParameter((BindingParameter)value, this.newBindingContext(propertyPath, propertyPath));
            regexValue = "$mn_qp:" + index;
        } else {
            regexValue = value.toString();
        }
        StringBuilder regexValueBuff = new StringBuilder();
        if (startsWith) {
            regexValueBuff.append("^");
        }
        regexValueBuff.append((String)regexValue);
        if (endsWith) {
            regexValueBuff.append("$");
        }
        regexCriteria.put(REGEX, regexValueBuff.toString());
        Map<String, Object> filterValue = negate ? Collections.singletonMap(NOT, regexCriteria) : regexCriteria;
        String criterionPropertyName = this.getCriterionPropertyName(criterion.getProperty(), context);
        obj.put(criterionPropertyName, filterValue);
    }

    private String getCriterionPropertyName(String name, CriteriaContext context) {
        PersistentEntity persistentEntity = context.getPersistentEntity();
        PersistentProperty identity = persistentEntity.getIdentity();
        if (identity != null && identity.getName().equals(name)) {
            return MONGO_ID_FIELD;
        }
        return name;
    }

    private String getPropertyPersistName(PersistentProperty property) {
        if (property.getOwner().getIdentity() == property) {
            return MONGO_ID_FIELD;
        }
        return property.getAnnotationMetadata().stringValue(SerdeConfig.class, "property").orElseGet(() -> ((PersistentProperty)property).getName());
    }

    private Object valueRepresentation(CriteriaContext context, PersistentPropertyPath propertyPath, Object value) {
        return this.valueRepresentation(context, propertyPath, propertyPath, value);
    }

    private Object valueRepresentation(CriteriaContext context, PersistentPropertyPath inPropertyPath, PersistentPropertyPath outPropertyPath, Object value) {
        if (value instanceof LocalDate) {
            return Collections.singletonMap(MONGO_DATE_IDENTIFIER, this.formatDate((LocalDate)value));
        }
        if (value instanceof LocalDateTime) {
            return Collections.singletonMap(MONGO_DATE_IDENTIFIER, this.formatDate((LocalDateTime)value));
        }
        if (value instanceof BindingParameter) {
            int index = context.pushParameter((BindingParameter)value, this.newBindingContext(inPropertyPath, outPropertyPath));
            return Collections.singletonMap(QUERY_PARAMETER_PLACEHOLDER, index);
        }
        return this.asLiteral(value);
    }

    private String formatDate(LocalDate localDate) {
        return this.formatDate(localDate.atStartOfDay());
    }

    private String formatDate(LocalDateTime localDateTime) {
        return this.formatDate(localDateTime.atZone(ZoneId.of("Z")).toInstant().toEpochMilli());
    }

    private String formatDate(long dateTime) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(dateTime), ZoneId.of("Z")).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    private <T extends QueryModel.PropertyComparisonCriterion> CriterionHandler<T> comparison(String operator) {
        return (ctx, obj, comparisonCriterion) -> {
            PersistentPropertyPath p1 = ctx.getRequiredProperty(comparisonCriterion.getProperty(), comparisonCriterion.getClass());
            PersistentPropertyPath p2 = ctx.getRequiredProperty(comparisonCriterion.getOtherProperty(), comparisonCriterion.getClass());
            obj.put("$expr", Collections.singletonMap(operator, Arrays.asList("$" + p1.getPath(), "$" + p2.getPath())));
        };
    }

    private Object asLiteral(@Nullable Object value) {
        if (value instanceof RegexPattern) {
            return "'" + Pattern.quote(((RegexPattern)value).value) + "'";
        }
        return value;
    }

    public QueryResult buildInsert(AnnotationMetadata repositoryMetadata, PersistentEntity entity) {
        return null;
    }

    public QueryResult buildQuery(AnnotationMetadata annotationMetadata, final QueryModel query) {
        ArgumentUtils.requireNonNull((String)"annotationMetadata", (Object)annotationMetadata);
        ArgumentUtils.requireNonNull((String)"query", (Object)query);
        final QueryState queryState = new QueryState(query, true);
        Map<Object, Object> predicateObj = new LinkedHashMap();
        LinkedHashMap<String, Object> group = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> projectionObj = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> countObj = new LinkedHashMap<String, Object>();
        this.addLookups(query.getJoinPaths(), queryState);
        List<Map<String, Object>> pipeline = queryState.rootLookups.pipeline;
        this.buildProjection(query.getProjections(), query.getPersistentEntity(), group, projectionObj, countObj);
        QueryModel.Junction criteria = query.getCriteria();
        if (!criteria.isEmpty()) {
            predicateObj = this.buildWhereClause(annotationMetadata, criteria, queryState);
        }
        if (!predicateObj.isEmpty()) {
            pipeline.add(Collections.singletonMap("$match", predicateObj));
        }
        if (!group.isEmpty()) {
            group.put(MONGO_ID_FIELD, null);
            pipeline.add(Collections.singletonMap("$group", group));
        }
        if (!countObj.isEmpty()) {
            pipeline.add(countObj);
        }
        if (!projectionObj.isEmpty()) {
            pipeline.add(Collections.singletonMap("$project", projectionObj));
        } else {
            String customProjection = annotationMetadata.stringValue("io.micronaut.data.mongodb.annotation.MongoProjection").orElse(null);
            if (customProjection != null) {
                pipeline.add(Collections.singletonMap("$project", new RawJsonValue(customProjection)));
            }
        }
        Sort sort = query.getSort();
        if (sort.isSorted() && !sort.getOrderBy().isEmpty()) {
            LinkedHashMap sortObj = new LinkedHashMap();
            sort.getOrderBy().forEach(order -> sortObj.put(order.getProperty(), order.isAscending() ? 1 : -1));
            pipeline.add(Collections.singletonMap("$sort", sortObj));
        } else {
            String customSort = annotationMetadata.stringValue("io.micronaut.data.mongodb.annotation.MongoSort").orElse(null);
            if (customSort != null) {
                pipeline.add(Collections.singletonMap("$sort", new RawJsonValue(customSort)));
            }
        }
        if (query.getOffset() > 0L) {
            pipeline.add(Collections.singletonMap("$skip", query.getOffset()));
        }
        if (query.getMax() != -1) {
            pipeline.add(Collections.singletonMap("$limit", query.getMax()));
        }
        final String q = pipeline.isEmpty() ? "{}" : (this.isMatchOnlyStage(pipeline) ? this.toJsonString(predicateObj) : this.toJsonString(pipeline));
        return new QueryResult(){

            @NonNull
            public String getQuery() {
                return q;
            }

            public int getMax() {
                return query.getMax();
            }

            public long getOffset() {
                return query.getOffset();
            }

            public List<String> getQueryParts() {
                return Collections.emptyList();
            }

            public List<QueryParameterBinding> getParameterBindings() {
                return queryState.getParameterBindings();
            }

            public Map<String, String> getAdditionalRequiredParameters() {
                return Collections.emptyMap();
            }
        };
    }

    private void addLookups(Collection<JoinPath> joins, QueryState queryState) {
        if (joins.isEmpty()) {
            return;
        }
        List joined = joins.stream().map(JoinPath::getPath).sorted((o1, o2) -> Comparator.comparingInt(String::length).thenComparing(String::compareTo).compare((String)o1, (String)o2)).collect(Collectors.toList());
        for (String join : joined) {
            StringJoiner rootPath = new StringJoiner(".");
            StringJoiner currentEntityPath = new StringJoiner(".");
            LookupsStage currentLookup = queryState.rootLookups;
            for (String path : StringUtils.splitOmitEmptyStrings((CharSequence)join, (char)'.')) {
                Association association;
                rootPath.add(path);
                currentEntityPath.add(path);
                String thisPath = currentEntityPath.toString();
                if (currentLookup.subLookups.containsKey(thisPath)) {
                    currentLookup = currentLookup.subLookups.get(path);
                    currentEntityPath = new StringJoiner(".");
                    continue;
                }
                PersistentPropertyPath propertyPath = currentLookup.persistentEntity.getPropertyPath(thisPath);
                PersistentProperty property = propertyPath.getProperty();
                if (!(property instanceof Association) || (association = (Association)property).getKind() == Relation.Kind.EMBEDDED) continue;
                LookupsStage lookupStage = new LookupsStage(association.getAssociatedEntity());
                List<Map<String, Object>> pipeline = currentLookup.pipeline;
                Optional<Association> inverseSide = association.getInverseSide().map(Function.identity());
                PersistentEntity persistentEntity = association.getOwner();
                String joinedCollectionName = association.getAssociatedEntity().getPersistedName();
                String ownerCollectionName = persistentEntity.getPersistedName();
                if (association.getKind() == Relation.Kind.MANY_TO_MANY || association.isForeignKey() && !inverseSide.isPresent()) {
                    PersistentEntity associatedEntity = association.getAssociatedEntity();
                    PersistentEntity associationOwner = association.getOwner();
                    PersistentProperty identity = associatedEntity.getIdentity();
                    if (identity == null) {
                        throw new IllegalArgumentException("Associated entity [" + associatedEntity.getName() + "] defines no ID. Cannot join.");
                    }
                    PersistentProperty associatedId = associationOwner.getIdentity();
                    if (associatedId == null) {
                        throw new MappingException("Cannot join on entity [" + associationOwner.getName() + "] that has no declared ID");
                    }
                    Association owningAssociation = inverseSide.orElse(association);
                    boolean isAssociationOwner = !association.getInverseSide().isPresent();
                    NamingStrategy namingStrategy = associationOwner.getNamingStrategy();
                    AnnotationMetadata annotationMetadata = owningAssociation.getAnnotationMetadata();
                    List<String> ownerJoinFields = this.resolveJoinTableAssociatedFields(annotationMetadata, isAssociationOwner, associationOwner, namingStrategy);
                    List<String> ownerJoinCollectionFields = this.resolveJoinTableJoinFields(annotationMetadata, isAssociationOwner, associationOwner, namingStrategy);
                    List<String> associationJoinFields = this.resolveJoinTableAssociatedFields(annotationMetadata, !isAssociationOwner, associatedEntity, namingStrategy);
                    List<String> associationJoinCollectionFields = this.resolveJoinTableJoinFields(annotationMetadata, !isAssociationOwner, associatedEntity, namingStrategy);
                    String joinCollectionName = namingStrategy.mappedName(owningAssociation);
                    ArrayList<Map<String, Object>> joinCollectionLookupPipeline = new ArrayList<Map<String, Object>>();
                    pipeline.add(this.lookup(joinCollectionName, MONGO_ID_FIELD, ownerCollectionName, joinCollectionLookupPipeline, thisPath));
                    joinCollectionLookupPipeline.add(this.lookup(joinedCollectionName, joinedCollectionName, MONGO_ID_FIELD, lookupStage.pipeline, joinedCollectionName));
                    joinCollectionLookupPipeline.add(this.unwind("$" + joinedCollectionName, true));
                    joinCollectionLookupPipeline.add(Collections.singletonMap("$replaceRoot", Collections.singletonMap("newRoot", "$" + joinedCollectionName)));
                } else {
                    String currentPath = this.asPath(propertyPath.getAssociations(), propertyPath.getProperty());
                    if (association.isForeignKey()) {
                        String mappedBy = (String)association.getAnnotationMetadata().stringValue(Relation.class, "mappedBy").orElseThrow(IllegalStateException::new);
                        PersistentPropertyPath mappedByPath = association.getAssociatedEntity().getPropertyPath(mappedBy);
                        if (mappedByPath == null) {
                            throw new IllegalStateException("Cannot find mapped path: " + mappedBy);
                        }
                        if (!(mappedByPath.getProperty() instanceof Association)) {
                            throw new IllegalStateException("Expected association as a mapped path: " + mappedBy);
                        }
                        ArrayList<String> localMatchFields = new ArrayList<String>();
                        ArrayList<String> foreignMatchFields = new ArrayList<String>();
                        this.traversePersistentProperties(currentLookup.persistentEntity.getIdentity(), (associations, p) -> {
                            String fieldPath = this.asPath((List<Association>)associations, (PersistentProperty)p);
                            localMatchFields.add(fieldPath);
                        });
                        ArrayList<Association> mappedAssociations = new ArrayList<Association>(mappedByPath.getAssociations());
                        mappedAssociations.add((Association)mappedByPath.getProperty());
                        this.traversePersistentProperties(mappedAssociations, currentLookup.persistentEntity.getIdentity(), (associations, p) -> {
                            String fieldPath = this.asPath((List<Association>)associations, (PersistentProperty)p);
                            foreignMatchFields.add(fieldPath);
                        });
                        pipeline.add(this.lookup(joinedCollectionName, localMatchFields, foreignMatchFields, lookupStage.pipeline, currentPath));
                    } else {
                        ArrayList<Association> mappedAssociations = new ArrayList<Association>(propertyPath.getAssociations());
                        mappedAssociations.add((Association)propertyPath.getProperty());
                        ArrayList<String> localMatchFields = new ArrayList<String>();
                        ArrayList<String> foreignMatchFields = new ArrayList<String>();
                        PersistentProperty identity = lookupStage.persistentEntity.getIdentity();
                        if (identity == null) {
                            throw new IllegalStateException("Null identity of persistent entity: " + lookupStage.persistentEntity);
                        }
                        this.traversePersistentProperties(mappedAssociations, identity, (associations, p) -> {
                            String fieldPath = this.asPath((List<Association>)associations, (PersistentProperty)p);
                            localMatchFields.add(fieldPath);
                        });
                        this.traversePersistentProperties(identity, (associations, p) -> {
                            String fieldPath = this.asPath((List<Association>)associations, (PersistentProperty)p);
                            foreignMatchFields.add(fieldPath);
                        });
                        pipeline.add(this.lookup(joinedCollectionName, localMatchFields, foreignMatchFields, lookupStage.pipeline, currentPath));
                    }
                    if (association.getKind().isSingleEnded()) {
                        pipeline.add(this.unwind("$" + currentPath, true));
                    }
                }
                currentLookup.subLookups.put(currentEntityPath.toString(), lookupStage);
            }
            queryState.joinPaths.add(join);
        }
    }

    @NonNull
    private List<String> resolveJoinTableJoinFields(AnnotationMetadata annotationMetadata, boolean associationOwner, PersistentEntity entity, NamingStrategy namingStrategy) {
        List<String> joinColumns = this.getJoinedFields(annotationMetadata, associationOwner, "name");
        if (!joinColumns.isEmpty()) {
            return joinColumns;
        }
        ArrayList<String> fields = new ArrayList<String>();
        this.traversePersistentProperties(entity.getIdentity(), (associations, property) -> fields.add(this.asPath((List<Association>)associations, (PersistentProperty)property)));
        return fields;
    }

    @NonNull
    private List<String> resolveJoinTableAssociatedFields(AnnotationMetadata annotationMetadata, boolean associationOwner, PersistentEntity entity, NamingStrategy namingStrategy) {
        List<String> joinColumns = this.getJoinedFields(annotationMetadata, associationOwner, "referencedColumnName");
        if (!joinColumns.isEmpty()) {
            return joinColumns;
        }
        PersistentProperty identity = entity.getIdentity();
        if (identity == null) {
            throw new MappingException("Cannot have a foreign key association without an ID on entity: " + entity.getName());
        }
        ArrayList<String> fields = new ArrayList<String>();
        this.traversePersistentProperties(identity, (associations, property) -> fields.add(this.asPath((List<Association>)associations, (PersistentProperty)property)));
        return fields;
    }

    @NonNull
    private List<String> getJoinedFields(AnnotationMetadata annotationMetadata, boolean associationOwner, String columnType) {
        return Collections.emptyList();
    }

    private String asPath(List<Association> associations, PersistentProperty property) {
        if (associations.isEmpty()) {
            return this.getPropertyPersistName(property);
        }
        StringJoiner joiner = new StringJoiner(".");
        for (Association association : associations) {
            joiner.add(this.getPropertyPersistName((PersistentProperty)association));
        }
        joiner.add(this.getPropertyPersistName(property));
        return joiner.toString();
    }

    private Map<String, Object> lookup(String from, String localField, String foreignField, List<Map<String, Object>> pipeline, String as) {
        LinkedHashMap<String, Object> lookup = new LinkedHashMap<String, Object>();
        lookup.put("from", from);
        lookup.put("localField", localField);
        lookup.put("foreignField", foreignField);
        lookup.put("pipeline", pipeline);
        lookup.put("as", as);
        return Collections.singletonMap("$lookup", lookup);
    }

    private Map<String, Object> lookup(String from, List<String> localFields, List<String> foreignFields, List<Map<String, Object>> pipeline, String as) {
        if (localFields.size() != foreignFields.size()) {
            throw new IllegalStateException("Un-matching join columns size: " + localFields.size() + " != " + foreignFields.size() + " " + localFields + ", " + foreignFields);
        }
        if (localFields.size() == 1) {
            return this.lookup(from, localFields.iterator().next(), foreignFields.iterator().next(), pipeline, as);
        }
        ArrayList<Map<String, List<String>>> matches = new ArrayList<Map<String, List<String>>>(localFields.size());
        LinkedHashMap<String, Object> let = new LinkedHashMap<String, Object>();
        int i = 1;
        Iterator<String> foreignIt = foreignFields.iterator();
        for (String localField : localFields) {
            String var = "v" + i++;
            let.put(var, "$" + localField);
            matches.add(Collections.singletonMap("$eq", Arrays.asList("$$" + var, "$" + foreignIt.next())));
        }
        Map<String, Object> match = matches.size() > 1 ? Collections.singletonMap("$match", Collections.singletonMap("$expr", Collections.singletonMap("$and", matches))) : Collections.singletonMap("$match", Collections.singletonMap("$expr", (Map)matches.iterator().next()));
        return this.lookup(from, let, match, pipeline, as);
    }

    private Map<String, Object> lookup(String from, Map<String, Object> let, Map<String, Object> match, List<Map<String, Object>> pipeline, String as) {
        pipeline.add(match);
        LinkedHashMap<String, Object> lookup = new LinkedHashMap<String, Object>();
        lookup.put("from", from);
        lookup.put("let", let);
        lookup.put("pipeline", pipeline);
        lookup.put("as", as);
        return Collections.singletonMap("$lookup", lookup);
    }

    private Map<String, Object> unwind(String path, boolean preserveNullAndEmptyArrays) {
        LinkedHashMap<String, Object> unwind = new LinkedHashMap<String, Object>();
        unwind.put("path", path);
        unwind.put("preserveNullAndEmptyArrays", preserveNullAndEmptyArrays);
        return Collections.singletonMap("$unwind", unwind);
    }

    private boolean isMatchOnlyStage(List<Map<String, Object>> pipeline) {
        return pipeline.size() == 1 && pipeline.iterator().next().containsKey("$match");
    }

    private Map<String, Object> buildWhereClause(AnnotationMetadata annotationMetadata, QueryModel.Junction criteria, final QueryState queryState) {
        CriteriaContext ctx = new CriteriaContext(){

            @Override
            public QueryState getQueryState() {
                return queryState;
            }

            @Override
            public PersistentEntity getPersistentEntity() {
                return queryState.getEntity();
            }

            @Override
            public PersistentPropertyPath getRequiredProperty(String name, Class<?> criterionClazz) {
                return MongoQueryBuilder.this.findProperty(queryState, name, criterionClazz);
            }
        };
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        this.handleCriterion(ctx, obj, (QueryModel.Criterion)criteria);
        return obj;
    }

    private void buildProjection(List<QueryModel.Projection> projectionList, PersistentEntity entity, Map<String, Object> groupObj, Map<String, Object> projectionObj, Map<String, Object> countObj) {
        if (!projectionList.isEmpty()) {
            for (QueryModel.Projection projection : projectionList) {
                if (projection instanceof QueryModel.LiteralProjection) {
                    QueryModel.LiteralProjection literalProjection = (QueryModel.LiteralProjection)projection;
                    projectionObj.put("val", Collections.singletonMap("$literal", this.asLiteral(literalProjection.getValue())));
                    continue;
                }
                if (projection instanceof QueryModel.CountProjection) {
                    countObj.put("$count", "result");
                    continue;
                }
                if (projection instanceof QueryModel.DistinctProjection) {
                    throw new UnsupportedOperationException("Not implemented yet");
                }
                if (projection instanceof QueryModel.IdProjection) {
                    projectionObj.put(MONGO_ID_FIELD, 1);
                    continue;
                }
                if (!(projection instanceof QueryModel.PropertyProjection)) continue;
                QueryModel.PropertyProjection pp = (QueryModel.PropertyProjection)projection;
                String propertyName = pp.getPropertyName();
                PersistentPropertyPath propertyPath = entity.getPropertyPath(propertyName);
                if (propertyPath == null) {
                    throw new IllegalArgumentException("Cannot project on non-existent property: " + propertyName);
                }
                String propertyPersistName = this.getPropertyPersistName(propertyPath.getProperty());
                if (projection instanceof QueryModel.AvgProjection) {
                    this.addProjection(groupObj, pp, "$avg", propertyPersistName);
                    continue;
                }
                if (projection instanceof QueryModel.SumProjection) {
                    this.addProjection(groupObj, pp, "$sum", propertyPersistName);
                    continue;
                }
                if (projection instanceof QueryModel.MinProjection) {
                    this.addProjection(groupObj, pp, "$min", propertyPersistName);
                    continue;
                }
                if (projection instanceof QueryModel.MaxProjection) {
                    this.addProjection(groupObj, pp, "$max", propertyPersistName);
                    continue;
                }
                if (projection instanceof QueryModel.CountDistinctProjection) {
                    throw new UnsupportedOperationException("Not implemented yet");
                }
                projectionObj.put(propertyPersistName, 1);
            }
        }
    }

    private void addProjection(Map<String, Object> groupBy, QueryModel.PropertyProjection pr, String op, String persistentPropertyName) {
        groupBy.put(pr.getAlias().orElse(pr.getPropertyName()), Collections.singletonMap(op, "$" + persistentPropertyName));
    }

    @NonNull
    private PersistentPropertyPath findProperty(QueryState queryState, String name, Class criterionType) {
        return this.findPropertyInternal(queryState, queryState.getEntity(), name, criterionType);
    }

    private PersistentPropertyPath findPropertyInternal(QueryState queryState, PersistentEntity entity, String name, Class criterionType) {
        PersistentPropertyPath propertyPath = entity.getPropertyPath(name);
        if (propertyPath != null) {
            String joinStringPath;
            if (propertyPath.getAssociations().isEmpty()) {
                return propertyPath;
            }
            Association joinAssociation = null;
            StringJoiner joinPathJoiner = new StringJoiner(".");
            for (Association association : propertyPath.getAssociations()) {
                joinPathJoiner.add(association.getName());
                if (association instanceof Embedded) continue;
                if (joinAssociation == null) {
                    joinAssociation = association;
                    continue;
                }
                if (association != joinAssociation.getAssociatedEntity().getIdentity()) {
                    if (!queryState.isAllowJoins()) {
                        throw new IllegalArgumentException("Joins cannot be used in a DELETE or UPDATE operation");
                    }
                    String joinStringPath2 = joinPathJoiner.toString();
                    if (!queryState.isJoined(joinStringPath2)) {
                        throw new IllegalArgumentException("Property is not joined at path: " + joinStringPath2);
                    }
                    joinAssociation = association;
                    continue;
                }
                joinAssociation = null;
            }
            PersistentProperty property = propertyPath.getProperty();
            if (joinAssociation != null && property != joinAssociation.getAssociatedEntity().getIdentity() && !queryState.isJoined(joinStringPath = joinPathJoiner.toString())) {
                throw new IllegalArgumentException("Property is not joined at path: " + joinStringPath);
            }
        } else if ("id".equals(name) && entity.getIdentity() != null) {
            return PersistentPropertyPath.of(Collections.emptyList(), (PersistentProperty)entity.getIdentity(), (String)entity.getIdentity().getName());
        }
        if (propertyPath == null) {
            if (criterionType == null || criterionType == Sort.Order.class) {
                throw new IllegalArgumentException("Cannot order on non-existent property path: " + name);
            }
            throw new IllegalArgumentException("Cannot use [" + criterionType.getSimpleName() + "] criterion on non-existent property path: " + name);
        }
        return propertyPath;
    }

    private void handleJunction(CriteriaContext ctx, Map<String, Object> query, QueryModel.Junction criteria, String operator) {
        if (criteria.getCriteria().size() == 1) {
            this.handleCriterion(ctx, query, (QueryModel.Criterion)criteria.getCriteria().iterator().next());
        } else {
            ArrayList<LinkedHashMap<String, Object>> ops = new ArrayList<LinkedHashMap<String, Object>>(criteria.getCriteria().size());
            query.put(operator, ops);
            for (QueryModel.Criterion criterion : criteria.getCriteria()) {
                LinkedHashMap<String, Object> criterionObj = new LinkedHashMap<String, Object>();
                ops.add(criterionObj);
                this.handleCriterion(ctx, criterionObj, criterion);
            }
        }
    }

    private void handleCriterion(CriteriaContext ctx, Map<String, Object> query, QueryModel.Criterion criterion) {
        CriterionHandler criterionHandler = this.queryHandlers.get(criterion.getClass());
        if (criterionHandler == null) {
            throw new IllegalArgumentException("Queries of type " + criterion.getClass().getSimpleName() + " are not supported by this implementation");
        }
        criterionHandler.handle(ctx, query, criterion);
    }

    public QueryResult buildUpdate(AnnotationMetadata annotationMetadata, QueryModel query, List<String> propertiesToUpdate) {
        throw new IllegalStateException("Only 'buildUpdate' with 'Map<String, Object> propertiesToUpdate' is supported");
    }

    public QueryResult buildUpdate(AnnotationMetadata annotationMetadata, QueryModel query, Map<String, Object> propertiesToUpdate) {
        ArgumentUtils.requireNonNull((String)"annotationMetadata", (Object)annotationMetadata);
        ArgumentUtils.requireNonNull((String)"query", (Object)query);
        ArgumentUtils.requireNonNull((String)"propertiesToUpdate", propertiesToUpdate);
        final QueryState queryState = new QueryState(query, true);
        QueryModel.Junction criteria = query.getCriteria();
        String predicateQuery = "";
        if (!criteria.isEmpty()) {
            Map<String, Object> predicate = this.buildWhereClause(annotationMetadata, criteria, queryState);
            predicateQuery = this.toJsonString(predicate);
        }
        LinkedHashMap<String, Object> sets = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> e : propertiesToUpdate.entrySet()) {
            PersistentPropertyPath propertyPath = this.findProperty(queryState, e.getKey(), null);
            String propertyPersistName = this.getPropertyPersistName(propertyPath.getProperty());
            if (e.getValue() instanceof BindingParameter) {
                int index = queryState.pushParameter((BindingParameter)e.getValue(), this.newBindingContext(propertyPath));
                sets.put(propertyPersistName, Collections.singletonMap(QUERY_PARAMETER_PLACEHOLDER, index));
                continue;
            }
            sets.put(propertyPersistName, e.getValue());
        }
        final String update = this.toJsonString(Collections.singletonMap("$set", sets));
        final String finalPredicateQuery = predicateQuery;
        return new QueryResult(){

            @NonNull
            public String getQuery() {
                return finalPredicateQuery;
            }

            public String getUpdate() {
                return update;
            }

            public List<String> getQueryParts() {
                return Collections.emptyList();
            }

            public List<QueryParameterBinding> getParameterBindings() {
                return queryState.getParameterBindings();
            }

            public Map<String, String> getAdditionalRequiredParameters() {
                return Collections.emptyMap();
            }
        };
    }

    public QueryResult buildDelete(AnnotationMetadata annotationMetadata, QueryModel query) {
        ArgumentUtils.requireNonNull((String)"annotationMetadata", (Object)annotationMetadata);
        ArgumentUtils.requireNonNull((String)"query", (Object)query);
        QueryState queryState = new QueryState(query, true);
        QueryModel.Junction criteria = query.getCriteria();
        String predicateQuery = "";
        if (!criteria.isEmpty()) {
            Map<String, Object> predicate = this.buildWhereClause(annotationMetadata, criteria, queryState);
            predicateQuery = this.toJsonString(predicate);
        }
        return QueryResult.of((String)predicateQuery, Collections.emptyList(), queryState.getParameterBindings(), queryState.getAdditionalRequiredParameters(), (int)query.getMax(), (long)query.getOffset());
    }

    public QueryResult buildOrderBy(PersistentEntity entity, Sort sort) {
        throw new UnsupportedOperationException();
    }

    public QueryResult buildPagination(Pageable pageable) {
        throw new UnsupportedOperationException();
    }

    private String toJsonString(Object obj) {
        StringBuilder sb = new StringBuilder();
        this.append(sb, obj);
        return sb.toString();
    }

    private void appendMap(StringBuilder sb, Map<String, Object> map) {
        sb.append("{");
        Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> e = iterator.next();
            String key = e.getKey();
            Object value = e.getValue();
            if (this.skipValue(value)) continue;
            if (this.shouldEscapeKey(key)) {
                sb.append("'").append(key).append("'");
            } else {
                sb.append(key);
            }
            sb.append(":");
            this.append(sb, value);
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
    }

    private boolean skipValue(Object obj) {
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        return false;
    }

    private void appendArray(StringBuilder sb, Collection<Object> collection) {
        sb.append("[");
        Iterator<Object> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            this.append(sb, value);
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append("]");
    }

    private void append(StringBuilder sb, Object obj) {
        if (obj instanceof Map) {
            this.appendMap(sb, (Map)obj);
        } else if (obj instanceof Collection) {
            this.appendArray(sb, (Collection)obj);
        } else if (obj instanceof RawJsonValue) {
            sb.append(((RawJsonValue)obj).value);
        } else if (obj == null) {
            sb.append("null");
        } else if (obj instanceof Boolean) {
            sb.append(obj.toString().toLowerCase(Locale.ROOT));
        } else if (obj instanceof Number) {
            sb.append(obj);
        } else {
            sb.append("'");
            sb.append(obj);
            sb.append("'");
        }
    }

    private boolean shouldEscapeKey(String s) {
        for (char c : s.toCharArray()) {
            if (Character.isAlphabetic(c) || Character.isDigit(c) || c == '$' || c == '_') continue;
            return true;
        }
        return false;
    }

    private <T extends QueryModel.Criterion> void addCriterionHandler(Class<T> clazz, CriterionHandler<T> handler) {
        this.queryHandlers.put(clazz, handler);
    }

    private BindingParameter.BindingContext newBindingContext(@Nullable PersistentPropertyPath ref) {
        return this.newBindingContext(ref, ref);
    }

    private BindingParameter.BindingContext newBindingContext(@Nullable PersistentPropertyPath in, @Nullable PersistentPropertyPath out) {
        return BindingParameter.BindingContext.create().incomingMethodParameterProperty(in).outgoingQueryParameterProperty(out);
    }

    private void traversePersistentProperties(PersistentProperty property, BiConsumer<List<Association>, PersistentProperty> consumer) {
        this.traversePersistentProperties(Collections.emptyList(), property, consumer);
    }

    private void traversePersistentProperties(List<Association> associations, PersistentProperty property, BiConsumer<List<Association>, PersistentProperty> consumerProperty) {
        PersistentEntityUtils.traversePersistentProperties(associations, (PersistentProperty)property, consumerProperty);
    }

    private static interface CriterionHandler<T extends QueryModel.Criterion> {
        public void handle(CriteriaContext var1, Map<String, Object> var2, T var3);
    }

    private static interface CriteriaContext
    extends PropertyParameterCreator {
        public QueryState getQueryState();

        public PersistentEntity getPersistentEntity();

        public PersistentPropertyPath getRequiredProperty(String var1, Class<?> var2);

        @Override
        default public int pushParameter(@NonNull BindingParameter bindingParameter, @NonNull BindingParameter.BindingContext bindingContext) {
            return this.getQueryState().pushParameter(bindingParameter, bindingContext);
        }

        default public PersistentPropertyPath getRequiredProperty(QueryModel.PropertyNameCriterion propertyCriterion) {
            return this.getRequiredProperty(propertyCriterion.getProperty(), propertyCriterion.getClass());
        }
    }

    private static final class RegexPattern {
        private final String value;

        private RegexPattern(String value) {
            this.value = value;
        }
    }

    @Internal
    protected final class QueryState
    implements PropertyParameterCreator {
        private final Set<String> joinPaths = new TreeSet<String>();
        private final AtomicInteger position = new AtomicInteger(0);
        private final Map<String, String> additionalRequiredParameters = new LinkedHashMap<String, String>();
        private final List<QueryParameterBinding> parameterBindings;
        private final boolean allowJoins;
        private final PersistentEntity entity;
        private final LookupsStage rootLookups;

        private QueryState(QueryModel query, boolean allowJoins) {
            this.allowJoins = allowJoins;
            this.entity = query.getPersistentEntity();
            this.parameterBindings = new ArrayList<QueryParameterBinding>(this.entity.getPersistentPropertyNames().size());
            this.rootLookups = new LookupsStage(this.entity);
        }

        public PersistentEntity getEntity() {
            return this.entity;
        }

        public boolean isAllowJoins() {
            return this.allowJoins;
        }

        public boolean isJoined(String associationPath) {
            for (String joinPath : this.joinPaths) {
                if (!joinPath.startsWith(associationPath)) continue;
                return true;
            }
            return this.joinPaths.contains(associationPath);
        }

        @NonNull
        public Map<String, String> getAdditionalRequiredParameters() {
            return this.additionalRequiredParameters;
        }

        public List<QueryParameterBinding> getParameterBindings() {
            return this.parameterBindings;
        }

        @Override
        public int pushParameter(@NonNull BindingParameter bindingParameter, @NonNull BindingParameter.BindingContext bindingContext) {
            int index = this.position.getAndIncrement();
            bindingContext = bindingContext.index(index);
            this.parameterBindings.add(bindingParameter.bind(bindingContext));
            return index;
        }
    }

    private static final class LookupsStage {
        private final PersistentEntity persistentEntity;
        private final List<Map<String, Object>> pipeline = new ArrayList<Map<String, Object>>();
        private final Map<String, LookupsStage> subLookups = new HashMap<String, LookupsStage>();

        private LookupsStage(PersistentEntity persistentEntity) {
            this.persistentEntity = persistentEntity;
        }
    }

    private static final class RawJsonValue {
        private final String value;

        private RawJsonValue(String value) {
            this.value = value;
        }
    }

    private static interface PropertyParameterCreator {
        public int pushParameter(@NonNull BindingParameter var1, @NonNull BindingParameter.BindingContext var2);
    }
}

