/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.document.serde.defaults;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.data.annotation.MappedProperty;
import io.micronaut.data.document.serde.CustomConverterSerializer;
import io.micronaut.data.model.runtime.AttributeConverterRegistry;
import io.micronaut.data.model.runtime.convert.AttributeConverter;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.util.CustomizableSerializer;
import jakarta.inject.Singleton;

@Internal
@Singleton
final class DefaultCustomConverterSerializer
implements CustomConverterSerializer,
CustomizableSerializer<Object> {
    private final AttributeConverterRegistry attributeConverterRegistry;

    public DefaultCustomConverterSerializer(AttributeConverterRegistry attributeConverterRegistry) {
        this.attributeConverterRegistry = attributeConverterRegistry;
    }

    @NonNull
    public Serializer<Object> createSpecific(Serializer.EncoderContext encoderContext, Argument<?> type) throws SerdeException {
        Class converterClass = (Class)type.getAnnotationMetadata().classValue(MappedProperty.class, "converter").orElseThrow(IllegalStateException::new);
        Class converterPersistedType = (Class)type.getAnnotationMetadata().classValue(MappedProperty.class, "converterPersistedType").orElseThrow(IllegalStateException::new);
        Argument convertedType = Argument.of((Class)converterPersistedType);
        Serializer serializer = encoderContext.findSerializer(convertedType);
        AttributeConverter converter = this.attributeConverterRegistry.getConverter(converterClass);
        return (encoder, context, type1, value) -> {
            Object converted = converter.convertToPersistedValue(value, (ConversionContext)ConversionContext.of((Argument)type1));
            if (converted == null) {
                encoder.encodeNull();
                return;
            }
            serializer.serialize(encoder, context, convertedType, converted);
        };
    }
}

