/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheus.rsocket;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.lang.Nullable;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.core.RSocketConnector;
import io.rsocket.transport.ClientTransport;
import io.rsocket.util.DefaultPayload;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.reactivestreams.Publisher;
import org.xerial.snappy.Snappy;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

public class PrometheusRSocketClient {
    private final MeterRegistryAndScrape<?> registryAndScrape;
    private volatile RSocket connection;
    private AtomicReference<PublicKey> latestKey = new AtomicReference();
    private volatile boolean requestedDisconnect = false;
    private RSocket sendingSocket;

    private PrometheusRSocketClient(final MeterRegistryAndScrape<?> registryAndScrape, ClientTransport transport, final Retry retry, final Runnable onKeyReceived) {
        this.registryAndScrape = registryAndScrape;
        RSocketConnector.create().reconnect(new Retry(){

            public Publisher<?> generateCompanion(Flux<Retry.RetrySignal> retrySignals) {
                return retry.generateCompanion(retrySignals.doOnNext(retrySignal -> {
                    Throwable failure = retrySignal.failure();
                    DistributionSummary.builder((String)"prometheus.connection.retry").description("Attempts at retrying an RSocket connection to the Prometheus proxy").baseUnit("retries").tag("exception", failure.getCause() != null ? failure.getCause().getMessage() : failure.getMessage()).register(registryAndScrape2.registry).record((double)retrySignal.totalRetries());
                }));
            }
        }).acceptor((payload, r) -> {
            this.sendingSocket = r;
            return Mono.just((Object)new RSocket(){

                public Mono<Payload> requestResponse(Payload payload) {
                    PublicKey key = PrometheusRSocketClient.this.decodePublicKey(payload.getData());
                    PrometheusRSocketClient.this.latestKey.set(key);
                    onKeyReceived.run();
                    return Mono.fromCallable(() -> PrometheusRSocketClient.this.scrapePayload(key));
                }

                public Mono<Void> fireAndForget(Payload payload) {
                    PrometheusRSocketClient.this.latestKey.set(PrometheusRSocketClient.this.decodePublicKey(payload.getData()));
                    onKeyReceived.run();
                    return Mono.empty();
                }
            });
        }).connect(transport).doOnError(t -> Counter.builder((String)"prometheus.connection.error").baseUnit("errors").tag("exception", t.getClass().getSimpleName() == null ? t.getClass().getName() : t.getClass().getSimpleName()).register(registryAndScrape.registry).increment()).doOnNext(connection -> {
            this.connection = connection;
        }).flatMap(socket -> socket.onClose().map(v -> 1).onErrorReturn((Object)1)).repeat(() -> !this.requestedDisconnect).subscribe();
    }

    public static Builder build(PrometheusMeterRegistry prometheusMeterRegistry, ClientTransport clientTransport) {
        return new Builder(prometheusMeterRegistry, () -> ((PrometheusMeterRegistry)prometheusMeterRegistry).scrape(), clientTransport);
    }

    public static <M extends MeterRegistry> Builder build(M meterRegistry, Supplier<String> scrape, ClientTransport clientTransport) {
        return new Builder(meterRegistry, scrape, clientTransport);
    }

    public void close() {
        this.requestedDisconnect = true;
        if (this.connection != null) {
            this.connection.dispose();
        }
    }

    public void pushAndClose() {
        PublicKey key = this.latestKey.get();
        if (key != null) {
            try {
                this.sendingSocket.fireAndForget(this.scrapePayload(key)).block(Duration.ofSeconds(1L));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.close();
    }

    private Payload scrapePayload(@Nullable PublicKey publicKey) throws Exception {
        String scrape = this.registryAndScrape.scrape();
        if (publicKey == null) {
            return DefaultPayload.create((CharSequence)scrape, (CharSequence)"plaintext");
        }
        KeyGenerator generator = KeyGenerator.getInstance("AES");
        generator.init(128);
        SecretKey secKey = generator.generateKey();
        Cipher aesCipher = Cipher.getInstance("AES");
        aesCipher.init(1, secKey);
        byte[] encryptedMetrics = aesCipher.doFinal(Snappy.compress((String)scrape));
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-256AndMGF1Padding");
        cipher.init(1, publicKey);
        byte[] encryptedPublicKey = cipher.doFinal(secKey.getEncoded());
        return DefaultPayload.create((byte[])encryptedMetrics, (byte[])encryptedPublicKey);
    }

    @Nullable
    private PublicKey decodePublicKey(ByteBuffer encodedKeyBuffer) {
        byte[] encodedKey = new byte[encodedKeyBuffer.capacity()];
        encodedKeyBuffer.get(encodedKey);
        if ("plaintext".equals(new String(encodedKey, StandardCharsets.UTF_8))) {
            return null;
        }
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encodedKey);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalStateException(e);
        }
    }

    private static class MeterRegistryAndScrape<M extends MeterRegistry> {
        final M registry;
        final Supplier<String> scrape;

        private MeterRegistryAndScrape(M registry, Supplier<String> scrape) {
            this.registry = registry;
            this.scrape = scrape;
        }

        String scrape() {
            return this.scrape.get();
        }

        /* synthetic */ MeterRegistryAndScrape(MeterRegistry x0, Supplier x1, 1 x2) {
            this(x0, x1);
        }
    }

    public static class Builder {
        private MeterRegistryAndScrape<?> registryAndScrape;
        private final ClientTransport clientTransport;
        private Retry retry = Retry.backoff((long)Long.MAX_VALUE, (Duration)Duration.ofSeconds(10L)).maxBackoff(Duration.ofMinutes(10L));
        private Runnable onKeyReceived = () -> {};

        <M extends MeterRegistry> Builder(M registry, Supplier<String> scrape, ClientTransport clientTransport) {
            this.registryAndScrape = new MeterRegistryAndScrape(registry, scrape, null);
            this.clientTransport = clientTransport;
        }

        public Builder retry(Retry retry) {
            this.retry = retry;
            return this;
        }

        public Builder doOnKeyReceived(Runnable onKeyReceived) {
            this.onKeyReceived = onKeyReceived;
            return this;
        }

        public PrometheusRSocketClient connect() {
            return new PrometheusRSocketClient(this.registryAndScrape, this.clientTransport, this.retry, this.onKeyReceived);
        }
    }
}

