/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.step;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.step.StepValue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

class StepDoubleMax
extends StepValue<Double> {
    private final AtomicLong current = new AtomicLong();

    public StepDoubleMax(Clock clock, long stepMillis) {
        super(clock, stepMillis);
    }

    @Override
    protected Supplier<Double> valueSupplier() {
        return () -> Double.longBitsToDouble(this.current.getAndSet(0L));
    }

    @Override
    protected Double noValue() {
        return 0.0;
    }

    void record(double amount) {
        this.current.updateAndGet(current -> Math.max(current, Double.doubleToLongBits(amount)));
    }
}

