/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.mongodb;

import com.mongodb.event.CommandFailedEvent;
import com.mongodb.event.CommandListener;
import com.mongodb.event.CommandStartedEvent;
import com.mongodb.event.CommandSucceededEvent;
import io.micrometer.core.annotation.Incubating;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.NonNullFields;
import java.util.concurrent.TimeUnit;

@NonNullApi
@NonNullFields
@Incubating(since="1.2.0")
public class MongoMetricsCommandListener
implements CommandListener {
    private final Timer.Builder timerBuilder = Timer.builder("mongodb.driver.commands").description("Timer of mongodb commands");
    private final MeterRegistry registry;

    public MongoMetricsCommandListener(MeterRegistry registry) {
        this.registry = registry;
    }

    public void commandStarted(CommandStartedEvent commandStartedEvent) {
    }

    public void commandSucceeded(CommandSucceededEvent event) {
        this.timerBuilder.tag("command", event.getCommandName()).tag("cluster.id", event.getConnectionDescription().getConnectionId().getServerId().getClusterId().getValue()).tag("server.address", event.getConnectionDescription().getServerAddress().toString()).tag("status", "SUCCESS").register(this.registry).record(event.getElapsedTime(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
    }

    public void commandFailed(CommandFailedEvent event) {
        this.timerBuilder.tag("command", event.getCommandName()).tag("cluster.id", event.getConnectionDescription().getConnectionId().getServerId().getClusterId().getValue()).tag("server.address", event.getConnectionDescription().getServerAddress().toString()).tag("status", "FAILED").register(this.registry).record(event.getElapsedTime(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
    }
}

