/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.jvm;

import io.micrometer.core.lang.NonNullApi;
import java.util.HashMap;
import java.util.Map;

@NonNullApi
enum GcGenerationAge {
    OLD,
    YOUNG,
    UNKNOWN;

    private static Map<String, GcGenerationAge> knownCollectors;

    static GcGenerationAge fromName(String name) {
        GcGenerationAge t = knownCollectors.get(name);
        return t == null ? UNKNOWN : t;
    }

    static {
        knownCollectors = new HashMap<String, GcGenerationAge>(){
            {
                this.put("ConcurrentMarkSweep", OLD);
                this.put("Copy", YOUNG);
                this.put("G1 Old Generation", OLD);
                this.put("G1 Young Generation", YOUNG);
                this.put("MarkSweepCompact", OLD);
                this.put("PS MarkSweep", OLD);
                this.put("PS Scavenge", YOUNG);
                this.put("ParNew", YOUNG);
            }
        };
    }
}

