/*
 * Decompiled with CFR 0.152.
 */
package io.michaelrocks.libphonenumber.android.metadata.source;

import io.michaelrocks.libphonenumber.android.MetadataLoader;
import io.michaelrocks.libphonenumber.android.Phonemetadata;
import io.michaelrocks.libphonenumber.android.internal.GeoEntityUtility;
import io.michaelrocks.libphonenumber.android.metadata.init.MetadataParser;
import io.michaelrocks.libphonenumber.android.metadata.source.BlockingMetadataBootstrappingGuard;
import io.michaelrocks.libphonenumber.android.metadata.source.MapBackedMetadataContainer;
import io.michaelrocks.libphonenumber.android.metadata.source.MetadataBootstrappingGuard;
import io.michaelrocks.libphonenumber.android.metadata.source.PhoneMetadataFileNameProvider;
import io.michaelrocks.libphonenumber.android.metadata.source.RegionMetadataSource;

public final class RegionMetadataSourceImpl
implements RegionMetadataSource {
    private final PhoneMetadataFileNameProvider phoneMetadataFileNameProvider;
    private final MetadataBootstrappingGuard<MapBackedMetadataContainer<String>> bootstrappingGuard;

    public RegionMetadataSourceImpl(PhoneMetadataFileNameProvider phoneMetadataFileNameProvider, MetadataBootstrappingGuard<MapBackedMetadataContainer<String>> bootstrappingGuard) {
        this.phoneMetadataFileNameProvider = phoneMetadataFileNameProvider;
        this.bootstrappingGuard = bootstrappingGuard;
    }

    public RegionMetadataSourceImpl(PhoneMetadataFileNameProvider phoneMetadataFileNameProvider, MetadataLoader metadataLoader, MetadataParser metadataParser) {
        this(phoneMetadataFileNameProvider, new BlockingMetadataBootstrappingGuard<MapBackedMetadataContainer<String>>(metadataLoader, metadataParser, MapBackedMetadataContainer.byRegionCode()));
    }

    @Override
    public Phonemetadata.PhoneMetadata getMetadataForRegion(String regionCode) {
        if (!GeoEntityUtility.isGeoEntity(regionCode)) {
            throw new IllegalArgumentException(regionCode + " region code is a non-geo entity");
        }
        return this.bootstrappingGuard.getOrBootstrap(this.phoneMetadataFileNameProvider.getFor(regionCode)).getMetadataBy(regionCode);
    }
}

