/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public abstract class SubclassJsonDeserializer<T>
extends JsonDeserializer<T> {
    public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        T bean;
        String fieldName;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        String type = node.get(fieldName = this.getTypeFieldName()).asText();
        Class<T> clazz = this.findClass(type);
        if (clazz == null) {
            return null;
        }
        try {
            bean = clazz.newInstance();
            this.deserialize(node, clazz, bean);
            for (Class<T> clazz2 = clazz.getSuperclass(); clazz2 != null && !clazz2.equals(Object.class); clazz2 = clazz2.getSuperclass()) {
                this.deserialize(node, clazz2, bean);
            }
        }
        catch (InstantiationException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e.getMessage(), e);
        }
        return bean;
    }

    protected void deserialize(JsonNode node, Class<?> clazz, T bean) throws IllegalArgumentException, IllegalAccessException {
        for (Field field : clazz.getDeclaredFields()) {
            Object value;
            field.setAccessible(true);
            Class<?> type = field.getType();
            String fieldName = field.getName();
            JsonNode node2 = node.get(fieldName);
            if (node2 == null) {
                value = null;
                continue;
            }
            if (type.equals(String.class)) {
                value = node2.textValue();
            } else if (type.equals(Boolean.TYPE)) {
                value = node2.booleanValue();
            } else if (type.equals(Boolean.class)) {
                String text = node2.asText();
                value = text == null ? null : Boolean.valueOf(node2.booleanValue());
            } else if (type.equals(Integer.TYPE)) {
                value = node2.intValue();
            } else if (type.equals(Long.TYPE)) {
                value = node2.longValue();
            } else if (type.equals(Float.TYPE)) {
                value = Float.valueOf(node2.floatValue());
            } else if (type.equals(Double.TYPE)) {
                value = node2.doubleValue();
            } else if (type.equals(Date.class)) {
                long time = node2.longValue();
                value = time == 0L ? null : new Date(time);
            } else if (List.class.equals(type)) {
                value = this.parseList(field, node2);
            } else {
                IllegalArgumentException e = new IllegalArgumentException("\u672a\u77e5\u6570\u636e\u7c7b\u578b[" + type.getName() + " fieldName:" + fieldName + "].");
                e.printStackTrace();
                value = null;
            }
            field.set(bean, value);
        }
    }

    protected Object parseList(Field field, JsonNode node) {
        ParameterizedType p = (ParameterizedType)field.getGenericType();
        Class clazz = (Class)p.getActualTypeArguments()[0];
        if (String.class.equals((Object)clazz)) {
            return this.parseListString(node);
        }
        throw new IllegalArgumentException("\u672a\u77e5\u6cdb\u578b[" + clazz.getName() + "].");
    }

    protected Object parseListString(JsonNode node) {
        Iterator elements = node.elements();
        ArrayList<String> list = null;
        if (elements != null) {
            list = new ArrayList<String>();
            while (elements.hasNext()) {
                JsonNode node3 = (JsonNode)elements.next();
                String text = node3.asText();
                list.add(text);
            }
        }
        return list;
    }

    protected abstract String getTypeFieldName();

    protected abstract Class<T> findClass(String var1);
}

