/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.leopard.json.DisablingJsonSerializerIntrospector;
import io.leopard.json.IJson;
import io.leopard.json.JsonException;
import io.leopard.lang.inum.Onum;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JsonJacksonImpl
implements IJson {
    private static ObjectMapper mapper = new ObjectMapper();
    private static ObjectMapper mapperIgnoreUnknownField = new ObjectMapper();
    private static ObjectWriter writer;

    @Override
    public String toFormatJson(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            return writer.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new JsonException(e.getMessage(), e);
        }
    }

    @Override
    public String toJson(Object obj) {
        try {
            String json = obj == null ? null : mapper.writeValueAsString(obj);
            return json;
        }
        catch (Exception e) {
            throw new JsonException(e.getMessage(), e);
        }
    }

    @Override
    public <T> List<T> toListObject(String json, Class<T> clazz) {
        if (json == null || json.length() == 0) {
            return null;
        }
        JavaType javaType = mapper.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, new Class[]{clazz});
        try {
            return (List)mapper.readValue(json, javaType);
        }
        catch (Exception e) {
            throw new JsonException(e.getMessage(), e);
        }
    }

    @Override
    public <T> List<T> toListObject(String json, Class<T> clazz, boolean ignoreUnknownField) {
        if (!ignoreUnknownField) {
            return this.toListObject(json, clazz);
        }
        if (json == null || json.length() == 0) {
            return null;
        }
        JavaType javaType = mapperIgnoreUnknownField.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, new Class[]{clazz});
        try {
            return (List)mapperIgnoreUnknownField.readValue(json, javaType);
        }
        catch (Exception e) {
            throw new JsonException(e.getMessage(), e);
        }
    }

    @Override
    public <T> T toObject(String json, Class<T> clazz) {
        return this.toObject(json, clazz, false);
    }

    @Override
    public <T> T toObject(String json, Class<T> clazz, boolean ignoreUnknownField) {
        if (json == null || json.length() == 0) {
            return null;
        }
        try {
            if (ignoreUnknownField) {
                return (T)mapperIgnoreUnknownField.readValue(json, clazz);
            }
            return (T)mapper.readValue(json, clazz);
        }
        catch (Exception e) {
            throw new JsonException(e.getMessage(), e);
        }
    }

    public static Object toList(String json, TypeReference<?> valueTypeRef) {
        if (json == null || json.length() == 0) {
            return null;
        }
        try {
            return mapper.readValue(json, valueTypeRef);
        }
        catch (Exception e) {
            throw new JsonException(e.getMessage(), e);
        }
    }

    @Override
    public <T> List<T> toListObject(List<String> jsonList, Class<T> clazz) {
        if (jsonList == null || jsonList.isEmpty()) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (String json : jsonList) {
            list.add(this.toObject(json, clazz));
        }
        return list;
    }

    @Override
    public <T> List<T> toListObject(List<String> jsonList, Class<T> clazz, boolean ignoreUnknownField) {
        if (jsonList == null || jsonList.isEmpty()) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (String json : jsonList) {
            list.add(this.toObject(json, clazz, ignoreUnknownField));
        }
        return list;
    }

    @Override
    public Map<String, Object> toMap(String json) {
        return this.toObject(json, Map.class);
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addSerializer((JsonSerializer)new OnumJsonSerializer());
        mapper.registerModule((Module)module);
        mapperIgnoreUnknownField.registerModule((Module)module);
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new DisablingJsonSerializerIntrospector());
        mapperIgnoreUnknownField.setAnnotationIntrospector((AnnotationIntrospector)new DisablingJsonSerializerIntrospector());
        writer = mapper.writer().withDefaultPrettyPrinter();
        mapperIgnoreUnknownField.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public static class OnumJsonSerializer
    extends StdSerializer<Onum<?, ?>> {
        private static final long serialVersionUID = 1L;

        public OnumJsonSerializer() {
            super(Onum.class, false);
        }

        public void serialize(Onum<?, ?> onum, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeObject(onum.getKey());
        }
    }
}

