/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import io.leopard.lang.inum.EnumUtil;
import io.leopard.lang.inum.Inum;
import io.leopard.lang.inum.Onum;
import io.leopard.lang.inum.Snum;
import java.io.IOException;

public class DisablingJsonSerializerIntrospector
extends JacksonAnnotationIntrospector {
    private static final long serialVersionUID = 1L;

    public Object findDeserializer(Annotated a) {
        Class clazz;
        if (a instanceof AnnotatedClass && (clazz = ((AnnotatedClass)a).getAnnotated()).isEnum() && Onum.class.isAssignableFrom(clazz)) {
            return new OnumJsonDeserializer(clazz);
        }
        Object deserializer = super.findDeserializer(a);
        return deserializer;
    }

    public Object findSerializer(Annotated am) {
        return null;
    }

    public Object findJsonSerializer(Annotated am) {
        return super.findSerializer(am);
    }

    private static class OnumJsonDeserializer
    extends JsonDeserializer<Onum<?, ?>> {
        private Class<?> clazz;

        public OnumJsonDeserializer(Class<?> clazz) {
            this.clazz = clazz;
        }

        public Onum<?, ?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonToken currentToken = jp.getCurrentToken();
            if (currentToken.equals((Object)JsonToken.START_OBJECT)) {
                return this.parseOnum(jp, ctxt);
            }
            if (Inum.class.isAssignableFrom(this.clazz)) {
                int key = jp.getIntValue();
                return (Onum)EnumUtil.toEnum((Object)key, this.clazz);
            }
            if (Snum.class.isAssignableFrom(this.clazz)) {
                String key = jp.getText();
                return (Onum)EnumUtil.toEnum((Object)key, this.clazz);
            }
            throw ctxt.mappingException("\u672a\u77e5\u679a\u4e3e\u7c7b\u578b[" + this.clazz.getName() + "].");
        }

        protected Onum<?, ?> parseOnum(JsonParser jp, DeserializationContext ctxt) throws JsonParseException, IOException {
            Object key;
            String fieldName = jp.getCurrentName();
            JsonToken currentToken = jp.nextToken();
            if (currentToken.equals((Object)JsonToken.END_OBJECT)) {
                return null;
            }
            if (!"key".equals(jp.getCurrentName())) {
                throw ctxt.mappingException("\u679a\u4e3e[" + fieldName + "]\u7684key\u5b57\u6bb5\u5fc5\u987b\u8981\u653e\u5728\u6700\u524d\u9762.");
            }
            jp.nextValue();
            if (Inum.class.isAssignableFrom(this.clazz)) {
                key = jp.getIntValue();
            } else if (Snum.class.isAssignableFrom(this.clazz)) {
                key = jp.getValueAsString();
            } else {
                throw ctxt.mappingException("\u672a\u77e5\u679a\u4e3e\u7c7b\u578b[" + this.clazz.getName() + "].");
            }
            this.nextToClose(jp, ctxt);
            if (key == null) {
                return null;
            }
            return (Onum)EnumUtil.toEnum((Object)key, this.clazz);
        }

        protected void nextToClose(JsonParser jp, DeserializationContext ctxt) throws JsonMappingException, IOException {
            JsonToken token;
            while ((token = jp.nextToken()) != JsonToken.END_OBJECT) {
            }
        }
    }
}

