/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.json;

import io.leopard.json.IJson;
import io.leopard.json.JsonException;
import java.util.List;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.map.type.TypeFactory;

public class JsonJacksonImpl
implements IJson {
    private static ObjectMapper mapper = new ObjectMapper();
    private static ObjectMapper mapperIgnoreUnknownField = new ObjectMapper();
    private static ObjectWriter writer = new ObjectMapper().writer().withDefaultPrettyPrinter();

    @Override
    public String toFormatJson(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            return writer.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new JsonException(e.getMessage(), e);
        }
    }

    @Override
    public String toJson(Object obj) {
        try {
            String json = obj == null ? null : mapper.writeValueAsString(obj);
            return json;
        }
        catch (Exception e) {
            throw new JsonException(e.getMessage(), e);
        }
    }

    @Override
    public <T> List<T> toListObject(String json, Class<T> clazz) {
        if (json == null || json.length() == 0) {
            return null;
        }
        try {
            return (List)mapper.readValue(json, TypeFactory.collectionType(List.class, clazz));
        }
        catch (Exception e) {
            throw new JsonException(e.getMessage(), e);
        }
    }

    @Override
    public <T> T toObject(String json, Class<T> clazz) {
        return JsonJacksonImpl.toObject(json, clazz, false);
    }

    public static <T> T toObject(String json, Class<T> clazz, boolean ignoreUnknownField) {
        if (json == null || json.length() == 0) {
            return null;
        }
        try {
            if (ignoreUnknownField) {
                return (T)mapperIgnoreUnknownField.readValue(json, clazz);
            }
            return (T)mapper.readValue(json, clazz);
        }
        catch (Exception e) {
            throw new JsonException(e.getMessage(), e);
        }
    }

    static {
        mapperIgnoreUnknownField.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

