/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.boot.requestmapping;

import io.leopard.boot.requestmapping.LeopardRequestMappingHandlerMapping;
import io.leopard.boot.requestmapping.PathLookupHandler;
import io.leopard.boot.requestmapping.custom.LeopardHttpHeaderRequestCondition;
import io.leopard.boot.requestmapping.custom.RequestHeaderMatcher;
import io.leopard.boot.requestmapping.custom.RequestHeaderResolver;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

public class ExtensibleRequestMappingHandlerMapping
extends LeopardRequestMappingHandlerMapping {
    @Autowired
    private RequestHeaderResolver requestHeaderResolver;
    @Autowired
    private PathLookupHandler pathLookupHandler;
    private Set<RequestMappingInfo> firstLookupRequestMappingInfoSet = new HashSet<RequestMappingInfo>();

    protected RequestCondition<?> getCustomMethodCondition(Method method) {
        LinkedHashSet<RequestHeaderMatcher> headerMatcherList = new LinkedHashSet<RequestHeaderMatcher>();
        this.requestHeaderResolver.resolve(method, headerMatcherList);
        if (headerMatcherList.isEmpty()) {
            return null;
        }
        return new LeopardHttpHeaderRequestCondition(headerMatcherList);
    }

    @Override
    protected RequestMappingInfo createMethodRequestMappingInfo(RequestMapping requestMapping, Method method) {
        RequestMappingInfo mapping = super.createMethodRequestMappingInfo(requestMapping, method);
        LeopardHttpHeaderRequestCondition condition = (LeopardHttpHeaderRequestCondition)mapping.getCustomCondition();
        if (condition != null && condition.isFirstLookup()) {
            this.firstLookupRequestMappingInfoSet.add(mapping);
        }
        return mapping;
    }

    protected HandlerMethod lookupHandlerMethod(String lookupPath, HttpServletRequest request) throws Exception {
        if (!this.firstLookupRequestMappingInfoSet.isEmpty()) {
            for (Map.Entry entry : this.getHandlerMethods().entrySet()) {
                RequestMappingInfo match;
                if (!this.firstLookupRequestMappingInfoSet.contains(entry.getKey()) || (match = this.getMatchingMapping((RequestMappingInfo)entry.getKey(), request)) == null || match.getCustomCondition() == null) continue;
                this.handleMatch(match, lookupPath, request);
                HandlerMethod method = (HandlerMethod)entry.getValue();
                return this.pathLookupHandler.transform(lookupPath, request, method);
            }
        }
        HandlerMethod method = super.lookupHandlerMethod(lookupPath, request);
        return this.pathLookupHandler.transform(lookupPath, request, method);
    }
}

