/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CertificatesV1Api;
import io.kubernetes.client.openapi.models.V1CertificateSigningRequest;
import io.kubernetes.client.openapi.models.V1CertificateSigningRequestCondition;
import io.kubernetes.client.openapi.models.V1CertificateSigningRequestSpec;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.util.exception.CSRNotApprovedException;
import io.kubernetes.client.util.exception.CSRSigningException;
import io.kubernetes.client.util.wait.Wait;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.security.KeyPair;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSRUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CSRUtils.class);
    public static final String CSR_USAGE_CLIENT_AUTH = "client auth";
    public static final String SIGNER_NAME_KUBE_APISERVER_CLIENT = "kubernetes.io/kube-apiserver-client";

    public static void approve(ApiClient apiClient, String csrObjName) throws ApiException {
        CertificatesV1Api api = new CertificatesV1Api(apiClient);
        OffsetDateTime now = OffsetDateTime.now();
        V1CertificateSigningRequest current = api.readCertificateSigningRequest(csrObjName, null);
        current.getStatus().addConditionsItem(new V1CertificateSigningRequestCondition().type(V1CertificateSigningRequestCondition.TypeEnum.APPROVED).status("True").reason("Kubernetes Java Client").lastTransitionTime(now).lastUpdateTime(now));
        api.replaceCertificateSigningRequestApproval(csrObjName, current, null, null, null, null);
    }

    public static byte[] createAndWaitUntilCertificateSigned(ApiClient bootstrapApiClient, V1CertificateSigningRequest csr) throws CSRNotApprovedException, ApiException {
        CertificatesV1Api api;
        V1CertificateSigningRequest existing;
        if (!CSRUtils.createIfAbsent(bootstrapApiClient, csr) && !CSRUtils.isIdentical(existing = (api = new CertificatesV1Api(bootstrapApiClient)).readCertificateSigningRequest(csr.getMetadata().getName(), null), csr)) {
            LOG.error("Existing CertificateSigningRequest object is conflicting with the requesting object");
            throw new IllegalStateException("Conflicting CSR object found in the cluster");
        }
        return CSRUtils.waitUntilCertificateSigned(bootstrapApiClient, csr.getMetadata().getName());
    }

    public static boolean createIfAbsent(ApiClient apiClient, V1CertificateSigningRequest csr) throws ApiException {
        CertificatesV1Api api = new CertificatesV1Api(apiClient);
        try {
            api.createCertificateSigningRequest(csr, null, null, null, null);
            return true;
        }
        catch (ApiException e) {
            if (e.getCode() == 409) {
                return false;
            }
            LOG.error("Failed creating CSR {} in the cluster: {}", (Object)csr.getMetadata().getName(), (Object)e.getResponseBody());
            throw e;
        }
    }

    public static byte[] waitUntilCertificateSigned(ApiClient apiClient, String csrObjectName) throws CSRNotApprovedException {
        return CSRUtils.waitUntilCertificateSigned(apiClient, csrObjectName, Duration.ofSeconds(5L), Duration.ofMinutes(30L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] waitUntilCertificateSigned(ApiClient apiClient, String csrObjectName, Duration retryInterval, Duration timeout) throws CSRNotApprovedException {
        CertificatesV1Api api = new CertificatesV1Api(apiClient);
        ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
        try {
            AtomicReference certRef = new AtomicReference();
            boolean certificateSigned = Wait.poll(retryInterval, timeout, () -> {
                try {
                    V1CertificateSigningRequest current = api.readCertificateSigningRequest(csrObjectName, null);
                    CSRUtils.getCertificate(current).ifPresent(cert -> certRef.set(cert));
                    return true;
                }
                catch (ApiException e) {
                    LOG.info("Failed acquiring latest state of CertificateSigningRequest resource {} from the cluster", (Object)csrObjectName);
                    return false;
                }
            });
            if (!certificateSigned) {
                LOG.error("Timeout exceed but the CertificateSigningRequest {} is not approved", (Object)csrObjectName);
                throw new CSRNotApprovedException("Timeout - CertificateSigningRequest not approved: " + csrObjectName);
            }
            LOG.info("Successfully acquired certificate from CertificateSigningRequest {}", (Object)csrObjectName);
            byte[] byArray = (byte[])certRef.get();
            return byArray;
        }
        finally {
            service.shutdown();
        }
    }

    public static Optional<byte[]> getCertificate(V1CertificateSigningRequest csr) {
        if (csr.getStatus() == null || csr.getStatus().getCertificate() == null) {
            return Optional.empty();
        }
        return Optional.of(csr.getStatus().getCertificate());
    }

    public static boolean isIdentical(V1CertificateSigningRequest left, V1CertificateSigningRequest right) {
        if (!Objects.equals(left.getSpec().getUsages(), right.getSpec().getUsages())) {
            return false;
        }
        return Objects.equals(left.getSpec().getSignerName(), right.getSpec().getSignerName());
    }

    public static byte[] sign(KeyPair keyPair, String commonName) throws CSRSigningException {
        return CSRUtils.sign(keyPair, "SHA512withRSA", commonName, "");
    }

    public static byte[] sign(KeyPair keyPair, String csrAlgo, String commonName, String organizationName) throws CSRSigningException {
        return CSRUtils.sign(keyPair, csrAlgo, String.join((CharSequence)", ", "CN=" + commonName, "O=" + organizationName));
    }

    public static byte[] sign(KeyPair keyPair, String csrAlgo, String subjects) throws CSRSigningException {
        try {
            JcaPKCS10CertificationRequestBuilder p10Builder = new JcaPKCS10CertificationRequestBuilder(new X500Principal(subjects), keyPair.getPublic());
            JcaContentSignerBuilder csBuilder = new JcaContentSignerBuilder(csrAlgo);
            ContentSigner signer = csBuilder.build(keyPair.getPrivate());
            PKCS10CertificationRequest csr = p10Builder.build(signer);
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bs);
            byte[] CRLF = new byte[]{13, 10};
            ps.println("-----BEGIN CERTIFICATE REQUEST-----");
            ps.println(Base64.getMimeEncoder(64, CRLF).encodeToString(csr.getEncoded()));
            ps.println("-----END CERTIFICATE REQUEST-----");
            return bs.toByteArray();
        }
        catch (IOException | OperatorCreationException e) {
            throw new CSRSigningException((Exception)e);
        }
    }

    public static V1CertificateSigningRequest newV1CertificateSigningRequest(String csrObjName, byte[] csrBytes) {
        return CSRUtils.newV1CertificateSigningRequest(csrObjName, csrBytes, SIGNER_NAME_KUBE_APISERVER_CLIENT, CSR_USAGE_CLIENT_AUTH);
    }

    public static V1CertificateSigningRequest newV1CertificateSigningRequest(String csrObjName, byte[] csrBytes, String signerName, String usage) {
        return new V1CertificateSigningRequest().metadata(new V1ObjectMeta().name(csrObjName)).spec(new V1CertificateSigningRequestSpec().request(csrBytes).signerName(signerName).addUsagesItem(usage));
    }
}

