/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.spring.extended.manifests.configmaps;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.kubernetes.client.apimachinery.NamespaceName;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import io.kubernetes.client.spring.extended.manifests.configmaps.ConfigMapGetter;
import java.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;

public class PollingConfigMapGetter
implements ConfigMapGetter {
    private static final Cache<NamespaceName, V1ConfigMap> lastObservedConfigMap = Caffeine.newBuilder().expireAfterWrite(Duration.ofMinutes(5L)).build();
    @Autowired
    private ApiClient apiClient;

    @Override
    public V1ConfigMap get(String namespace, String name) {
        CoreV1Api coreV1Api = new CoreV1Api(this.apiClient);
        return (V1ConfigMap)lastObservedConfigMap.get((Object)new NamespaceName(namespace, name), k -> {
            try {
                return coreV1Api.readNamespacedConfigMap(name, namespace).execute();
            }
            catch (ApiException e) {
                throw new IllegalStateException(e);
            }
        });
    }
}

