/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.monitoring.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="RelabelConfig allows dynamic rewriting of the label set, being applied to samples before ingestion. It defines `<metric_relabel_configs>`-section of Prometheus configuration. More info: https://prometheus.io/docs/prometheus/latest/configuration/configuration/#metric_relabel_configs")
public class V1ServiceMonitorSpecMetricRelabelings {
    public static final String SERIALIZED_NAME_ACTION = "action";
    @SerializedName(value="action")
    private String action;
    public static final String SERIALIZED_NAME_MODULUS = "modulus";
    @SerializedName(value="modulus")
    private Long modulus;
    public static final String SERIALIZED_NAME_REGEX = "regex";
    @SerializedName(value="regex")
    private String regex;
    public static final String SERIALIZED_NAME_REPLACEMENT = "replacement";
    @SerializedName(value="replacement")
    private String replacement;
    public static final String SERIALIZED_NAME_SEPARATOR = "separator";
    @SerializedName(value="separator")
    private String separator;
    public static final String SERIALIZED_NAME_SOURCE_LABELS = "sourceLabels";
    @SerializedName(value="sourceLabels")
    private List<String> sourceLabels = null;
    public static final String SERIALIZED_NAME_TARGET_LABEL = "targetLabel";
    @SerializedName(value="targetLabel")
    private String targetLabel;

    public V1ServiceMonitorSpecMetricRelabelings action(String action) {
        this.action = action;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Action to perform based on regex matching. Default is 'replace'")
    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public V1ServiceMonitorSpecMetricRelabelings modulus(Long modulus) {
        this.modulus = modulus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Modulus to take of the hash of the source label values.")
    public Long getModulus() {
        return this.modulus;
    }

    public void setModulus(Long modulus) {
        this.modulus = modulus;
    }

    public V1ServiceMonitorSpecMetricRelabelings regex(String regex) {
        this.regex = regex;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Regular expression against which the extracted value is matched. Default is '(.*)'")
    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public V1ServiceMonitorSpecMetricRelabelings replacement(String replacement) {
        this.replacement = replacement;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Replacement value against which a regex replace is performed if the regular expression matches. Regex capture groups are available. Default is '$1'")
    public String getReplacement() {
        return this.replacement;
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    public V1ServiceMonitorSpecMetricRelabelings separator(String separator) {
        this.separator = separator;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Separator placed between concatenated source label values. default is ';'.")
    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public V1ServiceMonitorSpecMetricRelabelings sourceLabels(List<String> sourceLabels) {
        this.sourceLabels = sourceLabels;
        return this;
    }

    public V1ServiceMonitorSpecMetricRelabelings addSourceLabelsItem(String sourceLabelsItem) {
        if (this.sourceLabels == null) {
            this.sourceLabels = new ArrayList<String>();
        }
        this.sourceLabels.add(sourceLabelsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The source labels select values from existing labels. Their content is concatenated using the configured separator and matched against the configured regular expression for the replace, keep, and drop actions.")
    public List<String> getSourceLabels() {
        return this.sourceLabels;
    }

    public void setSourceLabels(List<String> sourceLabels) {
        this.sourceLabels = sourceLabels;
    }

    public V1ServiceMonitorSpecMetricRelabelings targetLabel(String targetLabel) {
        this.targetLabel = targetLabel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Label to which the resulting value is written in a replace action. It is mandatory for replace actions. Regex capture groups are available.")
    public String getTargetLabel() {
        return this.targetLabel;
    }

    public void setTargetLabel(String targetLabel) {
        this.targetLabel = targetLabel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ServiceMonitorSpecMetricRelabelings v1ServiceMonitorSpecMetricRelabelings = (V1ServiceMonitorSpecMetricRelabelings)o;
        return Objects.equals(this.action, v1ServiceMonitorSpecMetricRelabelings.action) && Objects.equals(this.modulus, v1ServiceMonitorSpecMetricRelabelings.modulus) && Objects.equals(this.regex, v1ServiceMonitorSpecMetricRelabelings.regex) && Objects.equals(this.replacement, v1ServiceMonitorSpecMetricRelabelings.replacement) && Objects.equals(this.separator, v1ServiceMonitorSpecMetricRelabelings.separator) && Objects.equals(this.sourceLabels, v1ServiceMonitorSpecMetricRelabelings.sourceLabels) && Objects.equals(this.targetLabel, v1ServiceMonitorSpecMetricRelabelings.targetLabel);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.modulus, this.regex, this.replacement, this.separator, this.sourceLabels, this.targetLabel);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ServiceMonitorSpecMetricRelabelings {\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    modulus: ").append(this.toIndentedString(this.modulus)).append("\n");
        sb.append("    regex: ").append(this.toIndentedString(this.regex)).append("\n");
        sb.append("    replacement: ").append(this.toIndentedString(this.replacement)).append("\n");
        sb.append("    separator: ").append(this.toIndentedString(this.separator)).append("\n");
        sb.append("    sourceLabels: ").append(this.toIndentedString(this.sourceLabels)).append("\n");
        sb.append("    targetLabel: ").append(this.toIndentedString(this.targetLabel)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

