/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.monitoring.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="QuerySpec defines the query command line flags when starting Prometheus.")
public class V1PrometheusSpecQuery {
    public static final String SERIALIZED_NAME_LOOKBACK_DELTA = "lookbackDelta";
    @SerializedName(value="lookbackDelta")
    private String lookbackDelta;
    public static final String SERIALIZED_NAME_MAX_CONCURRENCY = "maxConcurrency";
    @SerializedName(value="maxConcurrency")
    private Integer maxConcurrency;
    public static final String SERIALIZED_NAME_MAX_SAMPLES = "maxSamples";
    @SerializedName(value="maxSamples")
    private Integer maxSamples;
    public static final String SERIALIZED_NAME_TIMEOUT = "timeout";
    @SerializedName(value="timeout")
    private String timeout;

    public V1PrometheusSpecQuery lookbackDelta(String lookbackDelta) {
        this.lookbackDelta = lookbackDelta;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The delta difference allowed for retrieving metrics during expression evaluations.")
    public String getLookbackDelta() {
        return this.lookbackDelta;
    }

    public void setLookbackDelta(String lookbackDelta) {
        this.lookbackDelta = lookbackDelta;
    }

    public V1PrometheusSpecQuery maxConcurrency(Integer maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of concurrent queries that can be run at once.")
    public Integer getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public void setMaxConcurrency(Integer maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
    }

    public V1PrometheusSpecQuery maxSamples(Integer maxSamples) {
        this.maxSamples = maxSamples;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Maximum number of samples a single query can load into memory. Note that queries will fail if they would load more samples than this into memory, so this also limits the number of samples a query can return.")
    public Integer getMaxSamples() {
        return this.maxSamples;
    }

    public void setMaxSamples(Integer maxSamples) {
        this.maxSamples = maxSamples;
    }

    public V1PrometheusSpecQuery timeout(String timeout) {
        this.timeout = timeout;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Maximum time a query may take before being aborted.")
    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PrometheusSpecQuery v1PrometheusSpecQuery = (V1PrometheusSpecQuery)o;
        return Objects.equals(this.lookbackDelta, v1PrometheusSpecQuery.lookbackDelta) && Objects.equals(this.maxConcurrency, v1PrometheusSpecQuery.maxConcurrency) && Objects.equals(this.maxSamples, v1PrometheusSpecQuery.maxSamples) && Objects.equals(this.timeout, v1PrometheusSpecQuery.timeout);
    }

    public int hashCode() {
        return Objects.hash(this.lookbackDelta, this.maxConcurrency, this.maxSamples, this.timeout);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PrometheusSpecQuery {\n");
        sb.append("    lookbackDelta: ").append(this.toIndentedString(this.lookbackDelta)).append("\n");
        sb.append("    maxConcurrency: ").append(this.toIndentedString(this.maxConcurrency)).append("\n");
        sb.append("    maxSamples: ").append(this.toIndentedString(this.maxSamples)).append("\n");
        sb.append("    timeout: ").append(this.toIndentedString(this.timeout)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

