/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.kubectl;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.extended.kubectl.Kubectl;
import io.kubernetes.client.extended.kubectl.exception.KubectlException;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.util.ModelMapper;
import org.apache.commons.lang3.StringUtils;

public class KubectlDelete<ApiType extends KubernetesObject>
extends Kubectl.ResourceBuilder<ApiType, KubectlDelete<ApiType>>
implements Kubectl.Executable<ApiType> {
    private boolean ignoreNotFound = false;

    KubectlDelete(Class<ApiType> apiTypeClass) {
        super(apiTypeClass);
    }

    public KubectlDelete<ApiType> ignoreNotFound(boolean ignore) {
        this.ignoreNotFound = ignore;
        return this;
    }

    @Override
    public ApiType execute() throws KubectlException {
        this.verifyArguments();
        this.refreshDiscovery();
        if (this.isNamespaced(this.apiTypeClass)) {
            try {
                return (ApiType)((KubernetesObject)this.getGenericApi().delete(this.namespace, this.name).throwsApiException().getObject());
            }
            catch (ApiException e) {
                if (this.ignoreNotFound && e.getCode() == 404) {
                    return null;
                }
                throw new KubectlException(e);
            }
        }
        try {
            return (ApiType)((KubernetesObject)this.getGenericApi().delete(this.name).throwsApiException().getObject());
        }
        catch (ApiException e) {
            if (this.ignoreNotFound && e.getCode() == 404) {
                return null;
            }
            throw new KubectlException(e);
        }
    }

    public boolean isNamespaced(Class<ApiType> apiTypeClass) {
        Boolean isNamespaced = ModelMapper.isNamespaced(apiTypeClass);
        if (isNamespaced == null) {
            return false;
        }
        return isNamespaced != false || !StringUtils.isEmpty((CharSequence)this.namespace);
    }

    private void verifyArguments() throws KubectlException {
        if (null == this.name) {
            throw new KubectlException("missing name argument");
        }
    }
}

