/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.event.legacy;

import io.kubernetes.client.openapi.models.CoreV1Event;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.joda.time.DateTime;

public class EventUtils {
    public static String generateName(String referencedObjectName, DateTime timestamp) {
        return referencedObjectName + "." + RandomStringUtils.randomAlphanumeric((int)12);
    }

    public static String getAggregatedMessageByReason(CoreV1Event event) {
        return "(combined from similar events): " + event.getMessage();
    }

    public static MutablePair<String, String> getAggregatedAndLocalKeyByReason(CoreV1Event event) {
        return new MutablePair((Object)String.join((CharSequence)"", event.getSource().getComponent(), event.getSource().getHost(), event.getInvolvedObject().getKind(), event.getInvolvedObject().getNamespace(), event.getInvolvedObject().getName(), event.getInvolvedObject().getUid(), event.getInvolvedObject().getApiVersion(), event.getType(), event.getReason()), (Object)event.getMessage());
    }

    public static String getEventKey(CoreV1Event event) {
        return String.join((CharSequence)"", event.getSource().getComponent(), event.getSource().getHost(), event.getInvolvedObject().getKind(), event.getInvolvedObject().getNamespace(), event.getInvolvedObject().getName(), event.getInvolvedObject().getFieldPath(), event.getInvolvedObject().getUid(), event.getInvolvedObject().getApiVersion(), event.getType(), event.getReason(), event.getMessage());
    }

    public static String getSpamKey(CoreV1Event event) {
        return String.join((CharSequence)"", event.getSource().getComponent(), event.getSource().getHost(), event.getInvolvedObject().getKind(), event.getInvolvedObject().getNamespace(), event.getInvolvedObject().getName(), event.getInvolvedObject().getUid(), event.getApiVersion());
    }
}

