/*
 * Decompiled with CFR 0.152.
 */
package io.cert.manager.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Challenge specifies a challenge offered by the ACME server for an Order. An appropriate Challenge resource can be created to perform the ACME challenge process.")
public class V1beta1OrderStatusChallenges {
    public static final String SERIALIZED_NAME_TOKEN = "token";
    @SerializedName(value="token")
    private String token;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private String url;

    public V1beta1OrderStatusChallenges token(String token) {
        this.token = token;
        return this;
    }

    @ApiModelProperty(required=true, value="Token is the token that must be presented for this challenge. This is used to compute the 'key' that must also be presented.")
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public V1beta1OrderStatusChallenges type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Type is the type of challenge being offered, e.g. 'http-01', 'dns-01', 'tls-sni-01', etc. This is the raw value retrieved from the ACME server. Only 'http-01' and 'dns-01' are supported by cert-manager, other values will be ignored.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public V1beta1OrderStatusChallenges url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(required=true, value="URL is the URL of this challenge. It can be used to retrieve additional metadata about the Challenge from the ACME server.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1OrderStatusChallenges v1beta1OrderStatusChallenges = (V1beta1OrderStatusChallenges)o;
        return Objects.equals(this.token, v1beta1OrderStatusChallenges.token) && Objects.equals(this.type, v1beta1OrderStatusChallenges.type) && Objects.equals(this.url, v1beta1OrderStatusChallenges.url);
    }

    public int hashCode() {
        return Objects.hash(this.token, this.type, this.url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1OrderStatusChallenges {\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

