/*
 * Decompiled with CFR 0.152.
 */
package io.cert.manager.models;

import com.google.gson.annotations.SerializedName;
import io.cert.manager.models.V1alpha2IssuerSpecAcmeDns01Route53SecretAccessKeySecretRef;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Use the AWS Route53 API to manage DNS01 challenge records.")
public class V1alpha2IssuerSpecAcmeDns01Route53 {
    public static final String SERIALIZED_NAME_ACCESS_KEY_I_D = "accessKeyID";
    @SerializedName(value="accessKeyID")
    private String accessKeyID;
    public static final String SERIALIZED_NAME_HOSTED_ZONE_I_D = "hostedZoneID";
    @SerializedName(value="hostedZoneID")
    private String hostedZoneID;
    public static final String SERIALIZED_NAME_REGION = "region";
    @SerializedName(value="region")
    private String region;
    public static final String SERIALIZED_NAME_ROLE = "role";
    @SerializedName(value="role")
    private String role;
    public static final String SERIALIZED_NAME_SECRET_ACCESS_KEY_SECRET_REF = "secretAccessKeySecretRef";
    @SerializedName(value="secretAccessKeySecretRef")
    private V1alpha2IssuerSpecAcmeDns01Route53SecretAccessKeySecretRef secretAccessKeySecretRef;

    public V1alpha2IssuerSpecAcmeDns01Route53 accessKeyID(String accessKeyID) {
        this.accessKeyID = accessKeyID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The AccessKeyID is used for authentication. If not set we fall-back to using env vars, shared credentials file or AWS Instance metadata see: https://docs.aws.amazon.com/sdk-for-go/v1/developer-guide/configuring-sdk.html#specifying-credentials")
    public String getAccessKeyID() {
        return this.accessKeyID;
    }

    public void setAccessKeyID(String accessKeyID) {
        this.accessKeyID = accessKeyID;
    }

    public V1alpha2IssuerSpecAcmeDns01Route53 hostedZoneID(String hostedZoneID) {
        this.hostedZoneID = hostedZoneID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set, the provider will manage only this zone in Route53 and will not do an lookup using the route53:ListHostedZonesByName api call.")
    public String getHostedZoneID() {
        return this.hostedZoneID;
    }

    public void setHostedZoneID(String hostedZoneID) {
        this.hostedZoneID = hostedZoneID;
    }

    public V1alpha2IssuerSpecAcmeDns01Route53 region(String region) {
        this.region = region;
        return this;
    }

    @ApiModelProperty(required=true, value="Always set the region when using AccessKeyID and SecretAccessKey")
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public V1alpha2IssuerSpecAcmeDns01Route53 role(String role) {
        this.role = role;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Role is a Role ARN which the Route53 provider will assume using either the explicit credentials AccessKeyID/SecretAccessKey or the inferred credentials from environment variables, shared credentials file or AWS Instance metadata")
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public V1alpha2IssuerSpecAcmeDns01Route53 secretAccessKeySecretRef(V1alpha2IssuerSpecAcmeDns01Route53SecretAccessKeySecretRef secretAccessKeySecretRef) {
        this.secretAccessKeySecretRef = secretAccessKeySecretRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1alpha2IssuerSpecAcmeDns01Route53SecretAccessKeySecretRef getSecretAccessKeySecretRef() {
        return this.secretAccessKeySecretRef;
    }

    public void setSecretAccessKeySecretRef(V1alpha2IssuerSpecAcmeDns01Route53SecretAccessKeySecretRef secretAccessKeySecretRef) {
        this.secretAccessKeySecretRef = secretAccessKeySecretRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha2IssuerSpecAcmeDns01Route53 v1alpha2IssuerSpecAcmeDns01Route53 = (V1alpha2IssuerSpecAcmeDns01Route53)o;
        return Objects.equals(this.accessKeyID, v1alpha2IssuerSpecAcmeDns01Route53.accessKeyID) && Objects.equals(this.hostedZoneID, v1alpha2IssuerSpecAcmeDns01Route53.hostedZoneID) && Objects.equals(this.region, v1alpha2IssuerSpecAcmeDns01Route53.region) && Objects.equals(this.role, v1alpha2IssuerSpecAcmeDns01Route53.role) && Objects.equals(this.secretAccessKeySecretRef, v1alpha2IssuerSpecAcmeDns01Route53.secretAccessKeySecretRef);
    }

    public int hashCode() {
        return Objects.hash(this.accessKeyID, this.hostedZoneID, this.region, this.role, this.secretAccessKeySecretRef);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha2IssuerSpecAcmeDns01Route53 {\n");
        sb.append("    accessKeyID: ").append(this.toIndentedString(this.accessKeyID)).append("\n");
        sb.append("    hostedZoneID: ").append(this.toIndentedString(this.hostedZoneID)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    secretAccessKeySecretRef: ").append(this.toIndentedString(this.secretAccessKeySecretRef)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

