package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V2beta2ResourceMetricStatusBuilder extends V2beta2ResourceMetricStatusFluentImpl<V2beta2ResourceMetricStatusBuilder> implements VisitableBuilder<V2beta2ResourceMetricStatus,V2beta2ResourceMetricStatusBuilder>{

    V2beta2ResourceMetricStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V2beta2ResourceMetricStatusBuilder(){
            this(true);
    }
    public V2beta2ResourceMetricStatusBuilder(Boolean validationEnabled){
            this(new V2beta2ResourceMetricStatus(), validationEnabled);
    }
    public V2beta2ResourceMetricStatusBuilder(V2beta2ResourceMetricStatusFluent<?> fluent){
            this(fluent, true);
    }
    public V2beta2ResourceMetricStatusBuilder(V2beta2ResourceMetricStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V2beta2ResourceMetricStatus(), validationEnabled);
    }
    public V2beta2ResourceMetricStatusBuilder(V2beta2ResourceMetricStatusFluent<?> fluent,V2beta2ResourceMetricStatus instance){
            this(fluent, instance, true);
    }
    public V2beta2ResourceMetricStatusBuilder(V2beta2ResourceMetricStatusFluent<?> fluent,V2beta2ResourceMetricStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCurrent(instance.getCurrent());

            fluent.withName(instance.getName());

            this.validationEnabled = validationEnabled; 
    }
    public V2beta2ResourceMetricStatusBuilder(V2beta2ResourceMetricStatus instance){
            this(instance,true);
    }
    public V2beta2ResourceMetricStatusBuilder(V2beta2ResourceMetricStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCurrent(instance.getCurrent());

            this.withName(instance.getName());

            this.validationEnabled = validationEnabled; 
    }

    public V2beta2ResourceMetricStatus build(){
            V2beta2ResourceMetricStatus buildable = new V2beta2ResourceMetricStatus();
            buildable.setCurrent(fluent.getCurrent());
            buildable.setName(fluent.getName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V2beta2ResourceMetricStatusBuilder that = (V2beta2ResourceMetricStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
