package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta2StatefulSetUpdateStrategyBuilder extends V1beta2StatefulSetUpdateStrategyFluentImpl<V1beta2StatefulSetUpdateStrategyBuilder> implements VisitableBuilder<V1beta2StatefulSetUpdateStrategy,V1beta2StatefulSetUpdateStrategyBuilder>{

    V1beta2StatefulSetUpdateStrategyFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta2StatefulSetUpdateStrategyBuilder(){
            this(true);
    }
    public V1beta2StatefulSetUpdateStrategyBuilder(Boolean validationEnabled){
            this(new V1beta2StatefulSetUpdateStrategy(), validationEnabled);
    }
    public V1beta2StatefulSetUpdateStrategyBuilder(V1beta2StatefulSetUpdateStrategyFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta2StatefulSetUpdateStrategyBuilder(V1beta2StatefulSetUpdateStrategyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta2StatefulSetUpdateStrategy(), validationEnabled);
    }
    public V1beta2StatefulSetUpdateStrategyBuilder(V1beta2StatefulSetUpdateStrategyFluent<?> fluent,V1beta2StatefulSetUpdateStrategy instance){
            this(fluent, instance, true);
    }
    public V1beta2StatefulSetUpdateStrategyBuilder(V1beta2StatefulSetUpdateStrategyFluent<?> fluent,V1beta2StatefulSetUpdateStrategy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRollingUpdate(instance.getRollingUpdate());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta2StatefulSetUpdateStrategyBuilder(V1beta2StatefulSetUpdateStrategy instance){
            this(instance,true);
    }
    public V1beta2StatefulSetUpdateStrategyBuilder(V1beta2StatefulSetUpdateStrategy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRollingUpdate(instance.getRollingUpdate());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta2StatefulSetUpdateStrategy build(){
            V1beta2StatefulSetUpdateStrategy buildable = new V1beta2StatefulSetUpdateStrategy();
            buildable.setRollingUpdate(fluent.getRollingUpdate());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta2StatefulSetUpdateStrategyBuilder that = (V1beta2StatefulSetUpdateStrategyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
