package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta2ScaleStatusBuilder extends V1beta2ScaleStatusFluentImpl<V1beta2ScaleStatusBuilder> implements VisitableBuilder<V1beta2ScaleStatus,V1beta2ScaleStatusBuilder>{

    V1beta2ScaleStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta2ScaleStatusBuilder(){
            this(true);
    }
    public V1beta2ScaleStatusBuilder(Boolean validationEnabled){
            this(new V1beta2ScaleStatus(), validationEnabled);
    }
    public V1beta2ScaleStatusBuilder(V1beta2ScaleStatusFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta2ScaleStatusBuilder(V1beta2ScaleStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta2ScaleStatus(), validationEnabled);
    }
    public V1beta2ScaleStatusBuilder(V1beta2ScaleStatusFluent<?> fluent,V1beta2ScaleStatus instance){
            this(fluent, instance, true);
    }
    public V1beta2ScaleStatusBuilder(V1beta2ScaleStatusFluent<?> fluent,V1beta2ScaleStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withReplicas(instance.getReplicas());

            fluent.withSelector(instance.getSelector());

            fluent.withTargetSelector(instance.getTargetSelector());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta2ScaleStatusBuilder(V1beta2ScaleStatus instance){
            this(instance,true);
    }
    public V1beta2ScaleStatusBuilder(V1beta2ScaleStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withReplicas(instance.getReplicas());

            this.withSelector(instance.getSelector());

            this.withTargetSelector(instance.getTargetSelector());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta2ScaleStatus build(){
            V1beta2ScaleStatus buildable = new V1beta2ScaleStatus();
            buildable.setReplicas(fluent.getReplicas());
            buildable.setSelector(fluent.getSelector());
            buildable.setTargetSelector(fluent.getTargetSelector());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta2ScaleStatusBuilder that = (V1beta2ScaleStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
