package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;

public class V1beta2DeploymentSpecFluentImpl<A extends V1beta2DeploymentSpecFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta2DeploymentSpecFluent<A>{

    private Integer minReadySeconds;
    private Boolean paused;
    private Integer progressDeadlineSeconds;
    private Integer replicas;
    private Integer revisionHistoryLimit;
    private V1LabelSelectorBuilder selector;
    private V1beta2DeploymentStrategyBuilder strategy;
    private V1PodTemplateSpecBuilder template;

    public V1beta2DeploymentSpecFluentImpl(){
    }
    public V1beta2DeploymentSpecFluentImpl(V1beta2DeploymentSpec instance){
            this.withMinReadySeconds(instance.getMinReadySeconds());

            this.withPaused(instance.getPaused());

            this.withProgressDeadlineSeconds(instance.getProgressDeadlineSeconds());

            this.withReplicas(instance.getReplicas());

            this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());

            this.withSelector(instance.getSelector());

            this.withStrategy(instance.getStrategy());

            this.withTemplate(instance.getTemplate());

    }

    public Integer getMinReadySeconds(){
            return this.minReadySeconds;
    }

    public A withMinReadySeconds(Integer minReadySeconds){
            this.minReadySeconds=minReadySeconds; return (A) this;
    }

    public Boolean hasMinReadySeconds(){
            return this.minReadySeconds != null;
    }

    public Boolean isPaused(){
            return this.paused;
    }

    public A withPaused(Boolean paused){
            this.paused=paused; return (A) this;
    }

    public Boolean hasPaused(){
            return this.paused != null;
    }

    public A withNewPaused(String arg1){
            return (A)withPaused(new Boolean(arg1));
    }

    public A withNewPaused(boolean arg1){
            return (A)withPaused(new Boolean(arg1));
    }

    public Integer getProgressDeadlineSeconds(){
            return this.progressDeadlineSeconds;
    }

    public A withProgressDeadlineSeconds(Integer progressDeadlineSeconds){
            this.progressDeadlineSeconds=progressDeadlineSeconds; return (A) this;
    }

    public Boolean hasProgressDeadlineSeconds(){
            return this.progressDeadlineSeconds != null;
    }

    public Integer getReplicas(){
            return this.replicas;
    }

    public A withReplicas(Integer replicas){
            this.replicas=replicas; return (A) this;
    }

    public Boolean hasReplicas(){
            return this.replicas != null;
    }

    public Integer getRevisionHistoryLimit(){
            return this.revisionHistoryLimit;
    }

    public A withRevisionHistoryLimit(Integer revisionHistoryLimit){
            this.revisionHistoryLimit=revisionHistoryLimit; return (A) this;
    }

    public Boolean hasRevisionHistoryLimit(){
            return this.revisionHistoryLimit != null;
    }

    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public V1LabelSelector getSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public V1LabelSelector buildSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(V1LabelSelector selector){
            _visitables.get("selector").remove(this.selector);
            if (selector!=null){ this.selector= new V1LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public Boolean hasSelector(){
            return this.selector != null;
    }

    public V1beta2DeploymentSpecFluent.SelectorNested<A> withNewSelector(){
            return new SelectorNestedImpl();
    }

    public V1beta2DeploymentSpecFluent.SelectorNested<A> withNewSelectorLike(V1LabelSelector item){
            return new SelectorNestedImpl(item);
    }

    public V1beta2DeploymentSpecFluent.SelectorNested<A> editSelector(){
            return withNewSelectorLike(getSelector());
    }

    public V1beta2DeploymentSpecFluent.SelectorNested<A> editOrNewSelector(){
            return withNewSelectorLike(getSelector() != null ? getSelector(): new V1LabelSelectorBuilder().build());
    }

    public V1beta2DeploymentSpecFluent.SelectorNested<A> editOrNewSelectorLike(V1LabelSelector item){
            return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStrategy instead.
 * @return The buildable object.
 */
@Deprecated public V1beta2DeploymentStrategy getStrategy(){
            return this.strategy!=null?this.strategy.build():null;
    }

    public V1beta2DeploymentStrategy buildStrategy(){
            return this.strategy!=null?this.strategy.build():null;
    }

    public A withStrategy(V1beta2DeploymentStrategy strategy){
            _visitables.get("strategy").remove(this.strategy);
            if (strategy!=null){ this.strategy= new V1beta2DeploymentStrategyBuilder(strategy); _visitables.get("strategy").add(this.strategy);} return (A) this;
    }

    public Boolean hasStrategy(){
            return this.strategy != null;
    }

    public V1beta2DeploymentSpecFluent.StrategyNested<A> withNewStrategy(){
            return new StrategyNestedImpl();
    }

    public V1beta2DeploymentSpecFluent.StrategyNested<A> withNewStrategyLike(V1beta2DeploymentStrategy item){
            return new StrategyNestedImpl(item);
    }

    public V1beta2DeploymentSpecFluent.StrategyNested<A> editStrategy(){
            return withNewStrategyLike(getStrategy());
    }

    public V1beta2DeploymentSpecFluent.StrategyNested<A> editOrNewStrategy(){
            return withNewStrategyLike(getStrategy() != null ? getStrategy(): new V1beta2DeploymentStrategyBuilder().build());
    }

    public V1beta2DeploymentSpecFluent.StrategyNested<A> editOrNewStrategyLike(V1beta2DeploymentStrategy item){
            return withNewStrategyLike(getStrategy() != null ? getStrategy(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public V1PodTemplateSpec getTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public V1PodTemplateSpec buildTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public A withTemplate(V1PodTemplateSpec template){
            _visitables.get("template").remove(this.template);
            if (template!=null){ this.template= new V1PodTemplateSpecBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public Boolean hasTemplate(){
            return this.template != null;
    }

    public V1beta2DeploymentSpecFluent.TemplateNested<A> withNewTemplate(){
            return new TemplateNestedImpl();
    }

    public V1beta2DeploymentSpecFluent.TemplateNested<A> withNewTemplateLike(V1PodTemplateSpec item){
            return new TemplateNestedImpl(item);
    }

    public V1beta2DeploymentSpecFluent.TemplateNested<A> editTemplate(){
            return withNewTemplateLike(getTemplate());
    }

    public V1beta2DeploymentSpecFluent.TemplateNested<A> editOrNewTemplate(){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): new V1PodTemplateSpecBuilder().build());
    }

    public V1beta2DeploymentSpecFluent.TemplateNested<A> editOrNewTemplateLike(V1PodTemplateSpec item){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1beta2DeploymentSpecFluentImpl that = (V1beta2DeploymentSpecFluentImpl) o;
            if (minReadySeconds != null ? !minReadySeconds.equals(that.minReadySeconds) :that.minReadySeconds != null) return false;
            if (paused != null ? !paused.equals(that.paused) :that.paused != null) return false;
            if (progressDeadlineSeconds != null ? !progressDeadlineSeconds.equals(that.progressDeadlineSeconds) :that.progressDeadlineSeconds != null) return false;
            if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
            if (revisionHistoryLimit != null ? !revisionHistoryLimit.equals(that.revisionHistoryLimit) :that.revisionHistoryLimit != null) return false;
            if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
            if (strategy != null ? !strategy.equals(that.strategy) :that.strategy != null) return false;
            if (template != null ? !template.equals(that.template) :that.template != null) return false;
            return true;
    }


    public class SelectorNestedImpl<N> extends V1LabelSelectorFluentImpl<V1beta2DeploymentSpecFluent.SelectorNested<N>> implements V1beta2DeploymentSpecFluent.SelectorNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1LabelSelectorBuilder builder;
    
            SelectorNestedImpl(V1LabelSelector item){
                    this.builder = new V1LabelSelectorBuilder(this, item);
            }
            SelectorNestedImpl(){
                    this.builder = new V1LabelSelectorBuilder(this);
            }
    
    public N and(){
            return (N) V1beta2DeploymentSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector(){
            return and();
    }

}
    public class StrategyNestedImpl<N> extends V1beta2DeploymentStrategyFluentImpl<V1beta2DeploymentSpecFluent.StrategyNested<N>> implements V1beta2DeploymentSpecFluent.StrategyNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1beta2DeploymentStrategyBuilder builder;
    
            StrategyNestedImpl(V1beta2DeploymentStrategy item){
                    this.builder = new V1beta2DeploymentStrategyBuilder(this, item);
            }
            StrategyNestedImpl(){
                    this.builder = new V1beta2DeploymentStrategyBuilder(this);
            }
    
    public N and(){
            return (N) V1beta2DeploymentSpecFluentImpl.this.withStrategy(builder.build());
    }
    public N endStrategy(){
            return and();
    }

}
    public class TemplateNestedImpl<N> extends V1PodTemplateSpecFluentImpl<V1beta2DeploymentSpecFluent.TemplateNested<N>> implements V1beta2DeploymentSpecFluent.TemplateNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1PodTemplateSpecBuilder builder;
    
            TemplateNestedImpl(V1PodTemplateSpec item){
                    this.builder = new V1PodTemplateSpecBuilder(this, item);
            }
            TemplateNestedImpl(){
                    this.builder = new V1PodTemplateSpecBuilder(this);
            }
    
    public N and(){
            return (N) V1beta2DeploymentSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate(){
            return and();
    }

}


}
