package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta2DaemonSetListBuilder extends V1beta2DaemonSetListFluentImpl<V1beta2DaemonSetListBuilder> implements VisitableBuilder<V1beta2DaemonSetList,V1beta2DaemonSetListBuilder>{

    V1beta2DaemonSetListFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta2DaemonSetListBuilder(){
            this(true);
    }
    public V1beta2DaemonSetListBuilder(Boolean validationEnabled){
            this(new V1beta2DaemonSetList(), validationEnabled);
    }
    public V1beta2DaemonSetListBuilder(V1beta2DaemonSetListFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta2DaemonSetListBuilder(V1beta2DaemonSetListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta2DaemonSetList(), validationEnabled);
    }
    public V1beta2DaemonSetListBuilder(V1beta2DaemonSetListFluent<?> fluent,V1beta2DaemonSetList instance){
            this(fluent, instance, true);
    }
    public V1beta2DaemonSetListBuilder(V1beta2DaemonSetListFluent<?> fluent,V1beta2DaemonSetList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta2DaemonSetListBuilder(V1beta2DaemonSetList instance){
            this(instance,true);
    }
    public V1beta2DaemonSetListBuilder(V1beta2DaemonSetList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta2DaemonSetList build(){
            V1beta2DaemonSetList buildable = new V1beta2DaemonSetList();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta2DaemonSetListBuilder that = (V1beta2DaemonSetListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
