package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1PodDisruptionBudgetSpecBuilder extends V1beta1PodDisruptionBudgetSpecFluentImpl<V1beta1PodDisruptionBudgetSpecBuilder> implements VisitableBuilder<V1beta1PodDisruptionBudgetSpec,V1beta1PodDisruptionBudgetSpecBuilder>{

    V1beta1PodDisruptionBudgetSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1PodDisruptionBudgetSpecBuilder(){
            this(true);
    }
    public V1beta1PodDisruptionBudgetSpecBuilder(Boolean validationEnabled){
            this(new V1beta1PodDisruptionBudgetSpec(), validationEnabled);
    }
    public V1beta1PodDisruptionBudgetSpecBuilder(V1beta1PodDisruptionBudgetSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1PodDisruptionBudgetSpecBuilder(V1beta1PodDisruptionBudgetSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1PodDisruptionBudgetSpec(), validationEnabled);
    }
    public V1beta1PodDisruptionBudgetSpecBuilder(V1beta1PodDisruptionBudgetSpecFluent<?> fluent,V1beta1PodDisruptionBudgetSpec instance){
            this(fluent, instance, true);
    }
    public V1beta1PodDisruptionBudgetSpecBuilder(V1beta1PodDisruptionBudgetSpecFluent<?> fluent,V1beta1PodDisruptionBudgetSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMaxUnavailable(instance.getMaxUnavailable());

            fluent.withMinAvailable(instance.getMinAvailable());

            fluent.withSelector(instance.getSelector());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1PodDisruptionBudgetSpecBuilder(V1beta1PodDisruptionBudgetSpec instance){
            this(instance,true);
    }
    public V1beta1PodDisruptionBudgetSpecBuilder(V1beta1PodDisruptionBudgetSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMaxUnavailable(instance.getMaxUnavailable());

            this.withMinAvailable(instance.getMinAvailable());

            this.withSelector(instance.getSelector());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1PodDisruptionBudgetSpec build(){
            V1beta1PodDisruptionBudgetSpec buildable = new V1beta1PodDisruptionBudgetSpec();
            buildable.setMaxUnavailable(fluent.getMaxUnavailable());
            buildable.setMinAvailable(fluent.getMinAvailable());
            buildable.setSelector(fluent.getSelector());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1PodDisruptionBudgetSpecBuilder that = (V1beta1PodDisruptionBudgetSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
